---
generated_at: 2026-01-08 15:10:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-ロール管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/role/role.html` - ロール一覧画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` - ロールコントローラー
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（20行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.19はロール管理一覧画面である | E-04 | ○ |
| C-02 | URLパターンは/system/role | E-02 (50行 @GetMapping()) | ○ |
| C-03 | system:role:view権限が必要 | E-02 (49行 @RequiresPermissions) | ○ |
| C-04 | 検索条件にroleName | E-01 (14行) | ○ |
| C-05 | 検索条件にroleKey | E-01 (17行) | ○ |
| C-06 | 検索条件にstatus | E-01 (20-23行) | ○ |
| C-07 | 検索条件にbeginTime/endTime | E-01 (27-29行) | ○ |
| C-08 | sortName: "roleSort" | E-01 (74行) | ○ |
| C-09 | 新規ボタンにsystem:role:add権限 | E-01 (41行 shiro:hasPermission) | ○ |
| C-10 | 編集ボタンにsystem:role:edit権限 | E-01 (44行 shiro:hasPermission) | ○ |
| C-11 | 削除ボタンにsystem:role:remove権限 | E-01 (47行 shiro:hasPermission) | ○ |
| C-12 | エクスポートにsystem:role:export権限 | E-01 (50行 shiro:hasPermission) | ○ |
| C-13 | roleIdカラム表示 | E-01 (80-82行) | ○ |
| C-14 | roleNameカラム（sortable） | E-01 (84-87行) | ○ |
| C-15 | roleKeyカラム（sortable） | E-01 (89-92行) | ○ |
| C-16 | dataScopeカラム（formatter） | E-01 (94-113行) | ○ |
| C-17 | dataScope=1で全部数据权限 | E-01 (97-98行 badge-primary) | ○ |
| C-18 | dataScope=2で自定义数据权限 | E-01 (100-101行 badge-success) | ○ |
| C-19 | dataScope=3で本部门数据权限 | E-01 (103-104行 badge-info) | ○ |
| C-20 | dataScope=4で本部门及以下 | E-01 (106-107行 badge-warning) | ○ |
| C-21 | dataScope=5で仅本人数据权限 | E-01 (109-110行 badge-danger) | ○ |
| C-22 | 状態トグル表示（statusTools） | E-01 (123-126行, 167-173行) | ○ |
| C-23 | roleId!=1で操作ボタン表示 | E-01 (136行) | ○ |
| C-24 | authDataScope関数 | E-01 (155-158行) | ○ |
| C-25 | authUser関数（openTab） | E-01 (161-164行) | ○ |
| C-26 | disable関数（status=1） | E-01 (176-180行) | ○ |
| C-27 | enable関数（status=0） | E-01 (183-187行) | ○ |
| C-28 | list()でselectRoleList呼び出し | E-02 (62行) | ○ |
| C-29 | remove()でdeleteRoleByIds呼び出し | E-02 (183行) | ○ |
| C-30 | changeStatus()でstatus更新 | E-02 (226行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 検索条件（roleName, roleKey, status, 日付範囲）が正しく記載されているか確認
- [ ] dataScopeのBadge表示（5種類）が正しいか確認
- [ ] roleId=1の操作ボタン非表示ロジックが正しいか確認
- [ ] 状態切替（enable/disable）の動作が正しく記載されているか確認
- [ ] 権限制御（view/list/add/edit/remove/export）が正しいか確認
