---
generated_at: 2026-01-08 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-ユーザー登録画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **sys_userテーブルのデフォルト値**：SysRegisterServiceの実装詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/register.html` - 登録画面テンプレート
- E-02: `ruoyi-admin/src/main/resources/static/ruoyi/register.js` - 登録処理JavaScript
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java` - 登録コントローラー
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 登録画面のURLは `/register` | E-03 (29行目 @GetMapping("/register")) | ○ |
| C-02 | POST `/register` で登録処理 | E-03 (35行目 @PostMapping("/register")) | ○ |
| C-03 | ユーザー名入力フィールドが存在（maxlength=20） | E-01 (44行目 input name="username" maxlength="20") | ○ |
| C-04 | パスワード入力フィールドが存在（maxlength=20） | E-01 (45行目 input name="password" maxlength="20") | ○ |
| C-05 | 確認パスワード入力フィールドが存在 | E-01 (46行目 input name="confirmPassword") | ○ |
| C-06 | 認証コード入力フィールドが存在（条件付き） | E-01 (47-56行目 th:if captchaEnabled) | ○ |
| C-07 | 利用規約チェックボックスが存在 | E-01 (57-59行目 input name="acceptTerm") | ○ |
| C-08 | 登録成功時はログイン画面にリダイレクト | E-02 (38行目 location.href = ctx + 'login') | ○ |
| C-09 | ログインリンクが存在 | E-01 (37行目 直接登录 th:href="@{/login}") | ○ |
| C-10 | キャプチャ画像クリックで更新 | E-02 (4-7行目 .imgcode click) | ○ |
| C-11 | ユーザー名の最小長は2文字 | E-02 (55-56行目 minlength: 2) | ○ |
| C-12 | パスワードの最小長は5文字 | E-02 (59-61行目 minlength: 5, specialSign) | ○ |
| C-13 | 確認パスワードはパスワードと一致必須 | E-02 (64-65行目 equalTo: "[name='password']") | ○ |
| C-14 | 機能No.20「ユーザー登録」が主機能 | E-04 (5行目) | ○ |
| C-15 | 機能No.21「キャプチャ生成」が補助機能 | E-04 (6行目) | ○ |
| C-16 | 登録機能の有効性チェック（sys.account.registerUser） | E-03 (39行目 configService.selectConfigByKey) | ○ |
| C-17 | 登録無効時は「当前系统没有开启注册功能！」 | E-03 (41行目 return error) | ○ |
| C-18 | registerServiceで登録処理 | E-03 (43行目 registerService.register) | ○ |
| C-19 | 成功時のアラートメッセージ | E-02 (31-39行目 layer.alert) | ○ |
| C-20 | 認証画面のカテゴリは「認証」 | E-05 (3行目) | ○ |
| C-21 | テンプレートファイルパスはregister.html | E-05 (3行目) | ○ |
| C-22 | 画面遷移：登録→ログイン | E-06 (83行目 Register --> Login) | ○ |
| C-23 | 利用規約リンクはGitee README | E-01 (59行目 href="https://gitee.com/y_project/RuoYi/blob/master/README.md") | ○ |
| C-24 | sys_userへのINSERTデフォルト値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- sys_userテーブルへのINSERT時のデフォルト値（create_by='register', remark='自主注册用户'等）はSysRegisterServiceの実装を直接確認する必要がある
  - 候補：`SysRegisterService.java` / `SysUserServiceImpl.java`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 画面表示・入力項目・イベント仕様は全てソースコードから確認済み
- **0: 低リスク** - バリデーションルールはregister.jsから詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] SysRegisterServiceのregister()メソッドでsys_userに設定されるデフォルト値を確認
- [ ] 登録時にロールが割り当てられないことを確認
