---
generated_at: 2026-01-08 15:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-ロール新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/role/add.html` - ロール新規登録画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` - ロールコントローラー（80-107行目、189-203行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（21行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.20はロール新規登録画面である | E-04 | ○ |
| C-02 | URLパターンは/system/role/add | E-02 (81行 @GetMapping("/add")) | ○ |
| C-03 | system:role:add権限が必要 | E-02 (80行 @RequiresPermissions) | ○ |
| C-04 | roleName入力項目（required） | E-01 (13行) | ○ |
| C-05 | roleKey入力項目（required） | E-01 (19行) | ○ |
| C-06 | roleKeyヘルプテキスト（@RequiresRoles） | E-01 (20行) | ○ |
| C-07 | roleSort入力項目（required） | E-01 (26行) | ○ |
| C-08 | statusトグル（checked初期値） | E-01 (33行) | ○ |
| C-09 | remark入力項目 | E-01 (41行) | ○ |
| C-10 | 展開/折りたたみチェック（value=1） | E-01 (48行) | ○ |
| C-11 | 全選択チェック（value=2） | E-01 (50行) | ○ |
| C-12 | 父子連動チェック（value=3, checked） | E-01 (52行) | ○ |
| C-13 | zTree初期化（id: menuTrees） | E-01 (64行) | ○ |
| C-14 | Ajax: /system/menu/roleMenuTreeData | E-01 (62行) | ○ |
| C-15 | check: { enable: true } | E-01 (66行) | ○ |
| C-16 | expandLevel: 0 | E-01 (67行) | ○ |
| C-17 | roleName重複チェック（remote） | E-01 (76-86行) | ○ |
| C-18 | roleKey重複チェック（remote） | E-01 (87-98行) | ○ |
| C-19 | roleSort数値チェック（digits） | E-01 (99-101行) | ○ |
| C-20 | expandAll(true/false)制御 | E-01 (118-122行) | ○ |
| C-21 | checkAllNodes(true/false)制御 | E-01 (124-128行) | ○ |
| C-22 | chkboxType設定変更 | E-01 (130-134行) | ○ |
| C-23 | $.tree.getCheckedNodes()でmenuIds取得 | E-01 (150行) | ○ |
| C-24 | status変換（checked→0, unchecked→1） | E-01 (148行) | ○ |
| C-25 | Ajax POST /system/role/add | E-01 (154行) | ○ |
| C-26 | サーバー側roleNameUnique検証 | E-02 (96-99行) | ○ |
| C-27 | サーバー側roleKeyUnique検証 | E-02 (100-103行) | ○ |
| C-28 | clearAllCachedAuthorizationInfo()呼び出し | E-02 (105行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全ての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] roleName/roleKey重複チェック（リモートバリデーション）が正しく記載されているか確認
- [ ] zTree初期化設定（check, expandLevel）が正しいか確認
- [ ] 展開/全選択/父子連動チェックボックスの動作が正しいか確認
- [ ] statusのトグル→数値変換ロジック（checked→0, unchecked→1）が正しいか確認
- [ ] menuIds取得（$.tree.getCheckedNodes()）の説明が正しいか確認
