---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：21-ロール編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **最大文字数制限**：remarkフィールドの500文字制限は推測値
  2. **成功メッセージ文言**：「操作成功」の具体的な文言確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/role/edit.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysRole.java`
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysRoleMapper.xml`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はモーダルダイアログとして表示される | E-01（wrapper-contentクラス使用） | ○ |
| C-02 | URLパスは /system/role/edit/{roleId} | E-02（114行目 @GetMapping） | ○ |
| C-03 | ロール名は30文字以内の制限 | E-04（100行目 @Size annotation） | ○ |
| C-04 | 権限字符は100文字以内の制限 | E-04（112行目 @Size annotation） | ○ |
| C-05 | ロール名重複チェックはremoteバリデーション | E-01（76-89行目 validate rules） | ○ |
| C-06 | system:role:edit権限が必要 | E-02（113行目 @RequiresPermissions） | ○ |
| C-07 | メニューツリーはzTreeで表示 | E-01（54行目 ztree-border class） | ○ |
| C-08 | 親子連動はデフォルトでチェック済み | E-01（53行目 checked属性） | ○ |
| C-09 | 保存時にsys_roleテーブルをUPDATE | E-05（95-108行目 updateRole） | ○ |
| C-10 | sys_role_menuの削除・再登録が行われる | E-03（85行目 updateRole定義） | ○ |
| C-11 | 管理者ロールは編集制限される | E-02（131行目 checkRoleAllowed） | ○ |
| C-12 | データスコープチェックが実行される | E-02（132行目 checkRoleDataScope） | ○ |
| C-13 | 権限キャッシュがクリアされる | E-02（142行目 clearAllCachedAuthorizationInfo） | ○ |
| C-14 | 状態は0:有効、1:無効 | E-04（40-41行目 status定義） | ○ |
| C-15 | 重複時のエラーメッセージ | E-01（111-116行目 messages設定） | ○ |
| C-16 | 表示順序は数字のみ許可 | E-01（106-108行目 digits:true） | ○ |
| C-17 | Ajax POSTで保存処理実行 | E-01（153-173行目 $.ajax） | ○ |
| C-18 | 展開/折叠機能がある | E-01（124-129行目 expandAll） | ○ |
| C-19 | 全選択/全解除機能がある | E-01（130-135行目 checkAllNodes） | ○ |
| C-20 | roleMenuTreeDataでメニューツリー取得 | E-01（63行目 url設定） | ○ |
| C-21 | update_timeはsysdate()で更新 | E-05（105行目 SQL） | ○ |
| C-22 | update_byはログインユーザー名 | E-02（141行目 setUpdateBy） | ○ |
| C-23 | 画面遷移はロール管理一覧から | E-08（RoleList -->|編集| RoleEdit） | ○ |
| C-24 | remarkは500文字以内 | **根拠なし** | △ |
| C-25 | 成功メッセージは「操作成功」 | **根拠不足**（共通メッセージ定義要確認） | △ |

## 4) 不足情報（Unknown / Missing）
- remarkフィールドの最大文字数制限：SysRoleエンティティおよびDBスキーマに明示的な制限が見当たらない
  - 候補：DDLファイル / データベース定義書 / フロントエンドバリデーション
- 成功メッセージの正確な文言：AjaxResult.success()の戻り値詳細
  - 候補：BaseController.java / AjaxResult.java / i18nメッセージファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで裏付けられている
- 1: 中リスク - remarkの文字数制限は実装時に確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] remarkフィールドの最大文字数をDB定義と照合する
- [ ] 成功メッセージの文言を実際の動作で確認する
- [ ] 管理者ロール編集時のエラーメッセージを確認する
- [ ] メニュー権限の反映タイミング（キャッシュクリア後）を確認する
