---
generated_at: 2026-01-08 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-ロールデータ権限設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **SQLレベルでのデータスコープ適用**：具体的な適用方法の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/role/dataScope.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysRole.java`
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysRoleMapper.xml`
- E-06: `ruoyi-system/src/main/resources/mapper/system/SysDeptMapper.xml`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /system/role/authDataScope/{roleId} | E-02（149行目 @GetMapping） | ○ |
| C-02 | データ範囲の選択肢は1-5の5種類 | E-01（26-31行目 select options） | ○ |
| C-03 | dataScope=2の場合のみ部門ツリーを表示 | E-01（36行目 th:style条件式、127-134行目） | ○ |
| C-04 | 部門ツリーは2階層まで初期展開 | E-01（60行目 expandLevel: 2） | ○ |
| C-05 | 展開/折叠チェックボックスはデフォルトチェック | E-01（40行目 checked属性） | ○ |
| C-06 | 親子連動チェックボックスはデフォルトチェック | E-01（44行目 checked属性） | ○ |
| C-07 | nocheckInheritはtrue | E-01（59行目 check設定） | ○ |
| C-08 | ロール名・権限字符は読み取り専用 | E-01（14行目、20行目 readonly="true"） | ○ |
| C-09 | 保存時にsys_roleのdata_scopeをUPDATE | E-05（101行目 data_scope更新） | ○ |
| C-10 | sys_role_deptの削除・再登録が行われる | E-03（93行目 authDataScope定義） | ○ |
| C-11 | 管理者ロールは操作制限される | E-02（166行目 checkRoleAllowed） | ○ |
| C-12 | データスコープチェックが実行される | E-02（167行目 checkRoleDataScope） | ○ |
| C-13 | 保存成功後にユーザー情報リロード | E-02（171行目 setSysUser） | ○ |
| C-14 | Ajax POSTで保存処理実行 | E-01（101-119行目 $.ajax） | ○ |
| C-15 | deptTreeDataで部門ツリー取得 | E-02（317-325行目 deptTreeData） | ○ |
| C-16 | dataScopeの値は1-5 | E-04（36-38行目 readConverterExp） | ○ |
| C-17 | 部門ツリーはselectRoleDeptTreeで取得 | E-06（30-36行目 SQL） | ○ |
| C-18 | dataScope変更時に部門ツリー表示/非表示切替 | E-01（122-134行目 dataScopeVisible関数） | ○ |
| C-19 | 部門ツリー非表示時は全解除される | E-01（131行目 checkAllNodes(false)） | ○ |
| C-20 | ロール管理一覧からデータ権限ボタンで遷移 | E-07（22行目 関連定義） | ○ |
| C-21 | update_byとupdate_timeが更新される | E-05（104-105行目） | ○ |
| C-22 | SQLレベルでデータスコープが適用される | **根拠不足**（DataScopeAspect等の確認要） | △ |

## 4) 不足情報（Unknown / Missing）
- データスコープのSQL適用メカニズム：DataScopeAspect.javaまたは類似のAOP実装
  - 候補：ruoyi-framework内のアスペクト実装 / MyBatisインターセプター

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面設計の大部分はソースコードで裏付けられている
- 1: 中リスク - データスコープのSQL適用については実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] データスコープのSQL適用メカニズムを確認する
- [ ] dataScope=2以外の場合の部門選択状態がクリアされることを確認する
- [ ] 管理者ロールでの画面表示時のエラーメッセージを確認する
- [ ] ユーザー情報リロードの目的と影響範囲を確認する
