---
generated_at: 2026-01-08 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-ロールユーザー割当

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、特に優先すべき項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/role/authUser.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /system/role/authUser/{roleId} | E-02（233行目 @GetMapping） | ○ |
| C-02 | 画面はページタブとして表示 | E-01（6行目 gray-bg class） | ○ |
| C-03 | 割当済みユーザー一覧取得API | E-02（245行目 /allocatedList） | ○ |
| C-04 | 単一解除API /authUser/cancel | E-02（259行目 @PostMapping） | ○ |
| C-05 | 一括解除API /authUser/cancelAll | E-02（271行目 @PostMapping） | ○ |
| C-06 | デフォルトソートは作成日時降順 | E-01（56-57行目 sortName/sortOrder） | ○ |
| C-07 | system:role:add権限で添加用户ボタン表示 | E-01（30行目 shiro:hasPermission） | ○ |
| C-08 | system:role:remove権限で解除ボタン表示 | E-01（33行目 shiro:hasPermission） | ○ |
| C-09 | 辞書sys_normal_disableでステータス変換 | E-01（49行目 @dict.getType） | ○ |
| C-10 | Bootstrap Tableを使用 | E-01（42行目 id="bootstrap-table"） | ○ |
| C-11 | チェックボックスカラムあり | E-01（58-59行目 checkbox: true） | ○ |
| C-12 | userIdは非表示カラム | E-01（62行目 visible: false） | ○ |
| C-13 | loginNameはソート可能 | E-01（67行目 sortable: true） | ○ |
| C-14 | createTimeはソート可能 | E-01（94行目 sortable: true） | ○ |
| C-15 | selectUser関数でダイアログ表示 | E-01（116-119行目） | ○ |
| C-16 | $.modal.openでダイアログ表示 | E-01（118行目） | ○ |
| C-17 | 選択なしで警告メッセージ表示 | E-01（125-126行目） | ○ |
| C-18 | 確認ダイアログ表示 | E-01（128行目 $.modal.confirm） | ○ |
| C-19 | roleIdとuserIdsをカンマ区切りで送信 | E-01（129行目 rows.join()） | ○ |
| C-20 | cancelAuthUser関数で単一解除 | E-01（135-139行目） | ○ |
| C-21 | closeItem関数で画面クローズ | E-01（36-38行目 onclick="closeItem()"） | ○ |
| C-22 | queryParamsでroleIdを追加 | E-01（109-113行目） | ○ |
| C-23 | データスコープチェックが実行される | E-02（236行目 checkRoleDataScope） | ○ |
| C-24 | ロール管理一覧から遷移 | E-05（RoleAuthUser記載） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 権限がない場合のボタン非表示を実際の画面で確認する
- [ ] 一括解除時の確認メッセージ内の件数表示を確認する
- [ ] ユーザー選択ダイアログからの戻りでテーブルが更新されることを確認する
