---
generated_at: 2026-01-08 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-ユーザー選択ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、特に優先すべき項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/role/selectUser.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /system/role/authUser/selectUser/{roleId} | E-02（282行目 @GetMapping） | ○ |
| C-02 | 画面はモーダルダイアログとして表示 | E-01（7行目 gray-bg class） | ○ |
| C-03 | 未割当ユーザー一覧取得API | E-02（293行目 /unallocatedList） | ○ |
| C-04 | 一括割当API /authUser/selectAll | E-02（307行目 @PostMapping） | ○ |
| C-05 | デフォルトソートは作成日時降順 | E-01（44-45行目 sortName/sortOrder） | ○ |
| C-06 | showSearch: false | E-01（46行目） | ○ |
| C-07 | showRefresh: false | E-01（47行目） | ○ |
| C-08 | showToggle: false | E-01（48行目） | ○ |
| C-09 | showColumns: false | E-01（49行目） | ○ |
| C-10 | clickToSelect: true | E-01（50行目） | ○ |
| C-11 | rememberSelected: true | E-01（51行目） | ○ |
| C-12 | 辞書sys_normal_disableでステータス変換 | E-01（37行目 @dict.getType） | ○ |
| C-13 | Bootstrap Tableを使用 | E-01（31行目 id="bootstrap-table"） | ○ |
| C-14 | チェックボックスカラムあり | E-01（53-54行目 checkbox: true） | ○ |
| C-15 | userIdは非表示カラム | E-01（57行目 visible: false） | ○ |
| C-16 | loginNameはソート可能 | E-01（62行目 sortable: true） | ○ |
| C-17 | createTimeはソート可能 | E-01（87行目 sortable: true） | ○ |
| C-18 | queryParamsでroleIdを追加 | E-01（95-99行目） | ○ |
| C-19 | 選択なしで警告メッセージ表示 | E-01（104-106行目） | ○ |
| C-20 | $.operate.saveで保存処理 | E-01（109行目） | ○ |
| C-21 | roleIdとuserIdsをカンマ区切りで送信 | E-01（108行目 rows.join()） | ○ |
| C-22 | データスコープチェックが実行される | E-02（311行目 checkRoleDataScope） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] rememberSelected機能で複数ページにまたがる選択が正しく動作することを確認する
- [ ] clickToSelect機能で行クリック時の選択動作を確認する
- [ ] 保存成功後に親画面のテーブルが更新されることを確認する
