---
generated_at: 2026-01-08 10:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-メニュー管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、特に優先すべき項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/menu/menu.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysMenuService.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java`
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysMenuMapper.xml`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /system/menu | E-02（40-45行目 @GetMapping） | ○ |
| C-02 | 一覧取得APIは POST /system/menu/list | E-02（47-55行目 @PostMapping） | ○ |
| C-03 | 削除APIは GET /system/menu/remove/{menuId} | E-02（60-76行目 @GetMapping） | ○ |
| C-04 | 並び順保存APIは POST /system/menu/updateSort | E-02（150-156行目 @PostMapping） | ○ |
| C-05 | system:menu:view権限でアクセス可能 | E-02（40行目 @RequiresPermissions） | ○ |
| C-06 | system:menu:add権限で新增ボタン表示 | E-01（32行目 shiro:hasPermission） | ○ |
| C-07 | system:menu:edit権限で修改ボタン表示 | E-01（35行目 shiro:hasPermission） | ○ |
| C-08 | system:menu:remove権限で削除リンク表示 | E-01（55行目 removeFlag変数） | ○ |
| C-09 | メニュー類型MはsucCess（緑）で目録表示 | E-01（119-120行目） | ○ |
| C-10 | メニュー類型Cはprimary（青）で菜単表示 | E-01（122-123行目） | ○ |
| C-11 | メニュー類型Fはwarning（黄）で按鈕表示 | E-01（125-126行目） | ○ |
| C-12 | 辞書sys_show_hideで可見状態変換 | E-01（56行目 @dict.getType） | ○ |
| C-13 | 按鈕タイプは可見列に「-」表示 | E-01（137-138行目） | ○ |
| C-14 | ツリーテーブルのコードはmenuId | E-01（62行目 code設定） | ○ |
| C-15 | 親コードはparentId | E-01（63行目 parentCode設定） | ○ |
| C-16 | 初期は折叠状態 | E-01（65-66行目 expandAll/expandFirst: false） | ○ |
| C-17 | 排序入力欄はインライン編集可能 | E-01（95-99行目 formatter） | ○ |
| C-18 | originalOrdersで変更検知 | E-01（58行目、98行目） | ○ |
| C-19 | 子メニュー存在で削除不可 | E-02（66-68行目 selectCountMenuByParentId） | ○ |
| C-20 | ロール割当済みで削除不可 | E-02（70-73行目 selectCountRoleMenuByMenuId） | ○ |
| C-21 | 削除時に権限キャッシュクリア | E-02（74行目 clearAllCachedAuthorizationInfo） | ○ |
| C-22 | saveSort関数で変更分のみ送信 | E-01（170-187行目） | ○ |
| C-23 | 変更なしで警告メッセージ | E-01（182-185行目 alertWarning） | ○ |
| C-24 | urlはツールチップ表示 | E-01（108-110行目 tooltip） | ○ |
| C-25 | permsはツールチップ表示 | E-01（149-151行目 tooltip） | ○ |
| C-26 | アイコン付きでメニュー名表示 | E-01（81-87行目 formatter） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 子メニュー存在時のエラーメッセージ表示を確認する
- [ ] ロール割当済み時のエラーメッセージ表示を確認する
- [ ] 並び順保存で変更分のみ送信されることを確認する
- [ ] ツリーの展開/折叠が正しく動作することを確認する
