---
generated_at: 2026-01-08 10:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-メニュー新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、特に優先すべき項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/menu/add.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysMenuService.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java`
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysMenuMapper.xml`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLは GET /system/menu/add/{parentId} | E-02（81-98行目 @GetMapping） | ○ |
| C-02 | データ保存APIは POST /system/menu/add | E-02（103-116行目 @PostMapping） | ○ |
| C-03 | メニュー名重複チェックAPIあり | E-02（checkMenuNameUnique()メソッド） | ○ |
| C-04 | system:menu:add権限でアクセス可能 | E-02（103行目 @RequiresPermissions） | ○ |
| C-05 | 菜単類型は M/C/F の3種類 | E-01（30-33行目 radio） | ○ |
| C-06 | 目録タイプでは請求地址非表示 | E-01（150-171行目 ifChecked） | ○ |
| C-07 | 菜単タイプでは全項目表示 | E-01（150-171行目 ifChecked） | ○ |
| C-08 | 按鈕タイプではurl/icon/target非表示 | E-01（150-171行目 ifChecked） | ○ |
| C-09 | 親メニュー選択はツリーダイアログ | E-01（174-186行目 selectMenuTree関数） | ○ |
| C-10 | アイコン選択ドロップダウンあり | E-01（137-149行目） | ○ |
| C-11 | バリデーション設定あり | E-01（98-129行目 rules） | ○ |
| C-12 | メニュー名重複時はエラー表示 | E-01（112行目 remote rule） | ○ |
| C-13 | parentId=0で新規SysMenuオブジェクト作成 | E-02（86-90行目） | ○ |
| C-14 | parentId!=0で親メニュー取得 | E-02（92-94行目 selectMenuById） | ○ |
| C-15 | 保存成功で権限キャッシュクリア | E-02（113行目 clearAllCachedAuthorizationInfo） | ○ |
| C-16 | 菜単状態は辞書sys_show_hideから取得 | E-01（75行目 @dict.getType） | ○ |
| C-17 | 打開方式はmenuItem/menuBlankの2択 | E-01（50-53行目 select） | ○ |
| C-18 | 顕示順序は必須入力 | E-01（104行目 required: true） | ○ |
| C-19 | 菜単名称は必須入力 | E-01（101行目 required: true） | ○ |
| C-20 | 図標はFont Awesomeアイコン | E-01（icon.htmlインクルード） | ○ |
| C-21 | モーダルダイアログとして表示 | E-01（1行目 gray-bg class） | ○ |
| C-22 | submitHandlerでフォーム送信 | E-01（133-135行目） | ○ |
| C-23 | sys_menuテーブルにINSERT | E-05（insertMenu SQL） | ○ |
| C-24 | create_byとcreate_time自動設定 | E-05（insertMenu SQL） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 菜単類型変更時の表示切替が正しく動作することを確認する
- [ ] 親メニューツリー選択ダイアログが正しく表示されることを確認する
- [ ] アイコン選択ドロップダウンが正しく動作することを確認する
- [ ] メニュー名重複チェックがリアルタイムで動作することを確認する
