---
generated_at: 2026-01-08 11:00:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-メニュー編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、特に優先すべき項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/menu/edit.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysMenuService.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java`
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysMenuMapper.xml`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLは GET /system/menu/edit/{menuId} | E-02（121-127行目 @GetMapping） | ○ |
| C-02 | データ保存APIは POST /system/menu/edit | E-02（132-145行目 @PostMapping） | ○ |
| C-03 | system:menu:edit権限でアクセス可能 | E-02（121,133行目 @RequiresPermissions） | ○ |
| C-04 | 菜単類型は M/C/F の3種類 | E-01（23-25行目 radio） | ○ |
| C-05 | menuIdをhidden項目で保持 | E-01（9行目 type="hidden"） | ○ |
| C-06 | parentIdをhidden項目で保持 | E-01（10行目 type="hidden"） | ○ |
| C-07 | 初期表示時にmenuTypeで表示制御 | E-01（99-102行目） | ○ |
| C-08 | 目録タイプでは請求地址非表示 | E-01（167-173行目 menuVisible） | ○ |
| C-09 | 菜単タイプでは全項目表示 | E-01（174-179行目 menuVisible） | ○ |
| C-10 | 按鈕タイプではurl/icon/target非表示 | E-01（180-186行目 menuVisible） | ○ |
| C-11 | 親メニュー選択はツリーダイアログ | E-01（200-214行目 selectMenuTree関数） | ○ |
| C-12 | 主菜单は親選択不可 | E-01（196,211行目 alertError） | ○ |
| C-13 | アイコン選択ドロップダウンあり | E-01（146-159行目） | ○ |
| C-14 | バリデーション設定あり | E-01（104-138行目 rules） | ○ |
| C-15 | 重複チェックでmenuIdを送信 | E-01（116-118行目） | ○ |
| C-16 | メニュー名重複時はエラー表示 | E-01（133-135行目 remote message） | ○ |
| C-17 | selectMenuById()でメニュー取得 | E-02（125行目） | ○ |
| C-18 | 保存成功で権限キャッシュクリア | E-02（143行目 clearAllCachedAuthorizationInfo） | ○ |
| C-19 | 菜単状態は辞書sys_show_hideから取得 | E-01（76行目 @dict.getType） | ○ |
| C-20 | 打開方式はmenuItem/menuBlankの2択 | E-01（43-46行目 select） | ○ |
| C-21 | 顕示順序はdigitsバリデーション | E-01（128-130行目 digits: true） | ○ |
| C-22 | 菜単名称は必須入力 | E-01（31行目 required） | ○ |
| C-23 | 図標はFont Awesomeアイコン | E-01（icon.htmlインクルード68行目） | ○ |
| C-24 | submitHandlerでフォーム送信 | E-01（140-144行目） | ○ |
| C-25 | updateMenu()でDB更新 | E-02（144行目） | ○ |
| C-26 | update_byをログインユーザーに設定 | E-02（142行目 setUpdateBy） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 主菜单（parentId=0）で親選択時にエラーが正しく表示されることを確認する
- [ ] 菜単類型変更時の表示切替が正しく動作することを確認する
- [ ] 重複チェックで自身のmenuIdが除外されることを確認する
- [ ] 保存成功後に親画面のツリーテーブルが更新されることを確認する
