---
generated_at: 2026-01-08 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-メニューツリー選択

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、特に優先すべき項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/menu/tree.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysMenuService.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLは GET /system/menu/selectMenuTree/{menuId} | E-02（203-209行目 @GetMapping） | ○ |
| C-02 | ツリーデータ取得APIは GET /system/menu/menuTreeData | E-02（192-199行目 @GetMapping） | ○ |
| C-03 | zTreeライブラリを使用 | E-01（5,29行目 ztree-css, ztree-js） | ○ |
| C-04 | hidden項目でtreeId保持 | E-01（12行目 type="hidden"） | ○ |
| C-05 | hidden項目でtreeName保持 | E-01（13行目 type="hidden"） | ○ |
| C-06 | 検索エリア表示切替ボタンあり | E-01（14-17行目 toggleSearch） | ○ |
| C-07 | キーワード検索機能あり | E-01（18-21行目 keyword, searchNode） | ○ |
| C-08 | 展開リンクあり | E-01（23行目 $.tree.expand()） | ○ |
| C-09 | 折叠リンクあり | E-01（24行目 $.tree.collapse()） | ○ |
| C-10 | 初期展開レベルは1 | E-01（35行目 expandLevel: 1） | ○ |
| C-11 | ノードクリックでzOnClick発火 | E-01（36,41-46行目 onClick: zOnClick） | ○ |
| C-12 | zOnClickでid取得 | E-01（42行目 treeNode.id） | ○ |
| C-13 | zOnClickでname取得 | E-01（43行目 treeNode.name） | ○ |
| C-14 | 選択値をhidden項目に設定 | E-01（44-45行目 val()） | ○ |
| C-15 | selectMenuById()でメニュー取得 | E-02（207行目） | ○ |
| C-16 | menuTreeData()でツリー取得 | E-02（196-197行目） | ○ |
| C-17 | userIdでフィルタリング | E-02（196行目 getUserId） | ○ |
| C-18 | キーワード検索最大50文字 | E-01（19行目 maxlength="50"） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] ツリーの展開/折叠が正しく動作することを確認する
- [ ] キーワード検索でノードがハイライトされることを確認する
- [ ] ノード選択後に親画面に値が正しく反映されることを確認する
- [ ] 検索エリアの表示/非表示切替が動作することを確認する
