---
generated_at: 2026-01-08 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-アイコン選択

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、特に優先すべき項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/menu/icon.html`
- E-02: `ruoyi-admin/src/main/resources/templates/system/menu/add.html`
- E-03: `ruoyi-admin/src/main/resources/templates/system/menu/edit.html`
- E-04: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 単独表示URLは GET /system/menu/icon | E-04（161-165行目 @GetMapping） | ○ |
| C-02 | Font Awesome 4.xを使用 | E-01（6行目 font-awesome.min.css） | ○ |
| C-03 | 約450種類のアイコン | E-01（24-926行目 約450の<i>要素） | ○ |
| C-04 | アイコンサイズは18px | E-01（13行目 font-size: 18px） | ○ |
| C-05 | パディングは5px | E-01（11行目 padding: 5px） | ○ |
| C-06 | ホバー時背景色#1d9d74 | E-01（18行目 background-color） | ○ |
| C-07 | ホバー時文字色白 | E-01（19行目 color: #ffffff） | ○ |
| C-08 | カーソルはpointer | E-01（12行目 cursor: pointer） | ○ |
| C-09 | add.htmlでインクルード | E-02（78行目 data-th-include） | ○ |
| C-10 | edit.htmlでインクルード | E-03（68行目 data-th-include） | ○ |
| C-11 | フォーカスで.icon-drop表示（add） | E-02（137-139行目） | ○ |
| C-12 | フォーカスで.icon-drop表示（edit） | E-03（147-149行目） | ○ |
| C-13 | クリックでclassを取得（add） | E-02（145-148行目） | ○ |
| C-14 | クリックでclassを取得（edit） | E-03（156-159行目） | ○ |
| C-15 | 入力欄外クリックで非表示（add） | E-02（140-144行目） | ○ |
| C-16 | 入力欄外クリックで非表示（edit） | E-03（150-155行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 図標入力欄フォーカスでドロップダウンが表示されることを確認する
- [ ] アイコンクリックで入力欄に値が設定されることを確認する
- [ ] 入力欄外クリックでドロップダウンが閉じることを確認する
- [ ] 約450種類のアイコンがスクロールで表示可能なことを確認する
