---
generated_at: 2026-01-08 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-画面ロック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/lock.html` - ロック画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` - インデックスコントローラー
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ロック画面のURLは `/lockscreen` | E-02 (92行目 @GetMapping("/lockscreen")) | ○ |
| C-02 | POST `/unlockscreen` でロック解除処理 | E-02 (101行目 @PostMapping("/unlockscreen")) | ○ |
| C-03 | パスワード入力フィールドが存在 | E-01 (25行目 input type="password" name="password") | ○ |
| C-04 | ユーザー名表示（loginName / userName形式） | E-01 (17行目 user.loginName / user.userName) | ○ |
| C-05 | ユーザーアバター表示 | E-01 (21行目 th:src user.avatar) | ○ |
| C-06 | リアルタイム時刻表示（500msごと更新） | E-01 (70-73行目 setInterval 500) | ○ |
| C-07 | ロック解除成功時は `/index` にリダイレクト | E-01 (105行目 location.href = ctx + 'index') | ○ |
| C-08 | パスワード未入力時エラー「请输入密码」 | E-01 (88-89行目 $.modal.msg) | ○ |
| C-09 | パスワード検証失敗時エラー「密码不正确」 | E-02 (115行目 return AjaxResult.error) | ○ |
| C-10 | セッションタイムアウト時エラー | E-02 (108行目 return AjaxResult.error) | ○ |
| C-11 | Enterキーでロック解除処理実行 | E-01 (78-82行目 keydown event.keyCode == 13) | ○ |
| C-12 | ログアウトリンク（/logout）が存在 | E-01 (35行目 th:href="@{logout}") | ○ |
| C-13 | Three.jsによる3Dパーティクル背景 | E-01 (40行目 three.min.js, 116-209行目) | ○ |
| C-14 | CSRF-Tokenをリクエストヘッダーに含める | E-01 (99-100行目 xhr.setRequestHeader) | ○ |
| C-15 | セッションにLOCK_SCREEN属性をセット | E-02 (96行目 setAttribute LOCK_SCREEN) | ○ |
| C-16 | ロック解除時にLOCK_SCREEN属性を削除 | E-02 (112行目 removeAttribute LOCK_SCREEN) | ○ |
| C-17 | passwordService.matches()でパスワード検証 | E-02 (110行目 passwordService.matches) | ○ |
| C-18 | 案内メッセージ「系统锁屏」表示 | E-01 (33行目 help-block text) | ○ |
| C-19 | 機能No.19「ログイン」が主機能 | E-03 (7行目) | ○ |
| C-20 | 認証カテゴリ「認証」 | E-04 (4行目) | ○ |
| C-21 | テンプレートファイルパスはlock.html | E-04 (4行目) | ○ |
| C-22 | 画面遷移：ロック→システム首頁 | E-05 (85行目 Lock --> Index) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認済み
- **0: 低リスク** - Three.jsアニメーションの詳細な動作は実行確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Three.jsパーティクルアニメーションの動作確認（ブラウザ互換性）
- [ ] CSRF-Token処理の正常動作確認
