---
generated_at: 2026-01-08 11:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-部門管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり、特に優先すべき項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/dept/dept.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysDeptService.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java`
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysDeptMapper.xml`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /system/dept | E-02（38-43行目 @GetMapping） | ○ |
| C-02 | 一覧取得APIは POST /system/dept/list | E-02（45-52行目 @PostMapping） | ○ |
| C-03 | 削除APIは GET /system/dept/remove/{deptId} | E-02（133-149行目 @GetMapping） | ○ |
| C-04 | system:dept:view権限でアクセス可能 | E-02（38行目 @RequiresPermissions） | ○ |
| C-05 | system:dept:add権限で新増ボタン表示 | E-01（32行目 shiro:hasPermission） | ○ |
| C-06 | system:dept:edit権限で修改ボタン表示 | E-01（35行目 shiro:hasPermission） | ○ |
| C-07 | 辞書sys_normal_disableで状態変換 | E-01（17,52,84行目） | ○ |
| C-08 | ツリーテーブルのコードはdeptId | E-01（57行目 code: "deptId"） | ○ |
| C-09 | 親コードはparentId | E-01（58行目 parentCode: "parentId"） | ○ |
| C-10 | ラジオボタン選択カラムあり | E-01（66-68行目 radio: true） | ○ |
| C-11 | 部門名称は左寄せ表示 | E-01（72行目 align: "left"） | ○ |
| C-12 | 操作カラムはparentId!=0で表示 | E-01（96-104行目 formatter条件） | ○ |
| C-13 | 新増ボタンの初期parentIdは100 | E-01（32行目 onclick="$.operate.add(100)"） | ○ |
| C-14 | 展開/折叠ボタンあり | E-01（38-40行目 expandAllBtn） | ○ |
| C-15 | 下位部門存在で削除不可 | E-02（139-142行目 selectDeptCount） | ○ |
| C-16 | ユーザー存在で削除不可 | E-02（143-146行目 checkDeptExistUser） | ○ |
| C-17 | データスコープチェックあり | E-02（147行目 checkDeptDataScope） | ○ |
| C-18 | 非管理者は自部門配下にのみ追加可能 | E-02（61-64行目 isAdmin条件） | ○ |
| C-19 | deptName最大30文字 | E-04（88行目 @Size） | ○ |
| C-20 | deptNameは必須 | E-04（87行目 @NotBlank） | ○ |
| C-21 | orderNumは必須 | E-04（99行目 @NotNull） | ○ |
| C-22 | 電話番号最大11文字 | E-04（120行目 @Size） | ○ |
| C-23 | メール形式バリデーション | E-04（131行目 @Email） | ○ |
| C-24 | メール最大50文字 | E-04（132行目 @Size） | ○ |
| C-25 | 検索フォームにdeptName入力欄 | E-01（14行目） | ○ |
| C-26 | 検索フォームにstatus選択欄 | E-01（17-20行目） | ○ |
| C-27 | treeTable.search()で検索実行 | E-01（23行目） | ○ |
| C-28 | form.reset()で検索条件リセット | E-01（24行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 下位部門存在時のエラーメッセージ表示を確認する
- [ ] ユーザー存在時のエラーメッセージ表示を確認する
- [ ] 非管理者ユーザーの新規登録時に自部門配下に制限されることを確認する
- [ ] ルート部門（parentId=0）に操作リンクが表示されないことを確認する
- [ ] ツリーの展開/折叠が正しく動作することを確認する
