---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：31-部門新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **メッセージIDの体系**：独自に定義したIDであり、実際のシステムと異なる可能性
  2. **電話番号形式チェック(isPhone)**：カスタムバリデータの実装詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/dept/add.html` - 画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java` - コントローラー
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java` - サービス実装
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` - エンティティ
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysDeptMapper.xml` - SQLマッパー
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは GET /system/dept/add/{parentId} | E-02 行58 | ○ |
| C-02 | 登録処理は POST /system/dept/add | E-02 行74 | ○ |
| C-03 | 部門名称は30文字以内 | E-04 行88 @Size(max=30) | ○ |
| C-04 | 部門名称は必須入力 | E-04 行87 @NotBlank | ○ |
| C-05 | 表示順序は必須入力 | E-04 行99 @NotNull | ○ |
| C-06 | メールアドレスは50文字以内 | E-04 行132 @Size(max=50) | ○ |
| C-07 | 電話番号は11文字以内 | E-04 行120 @Size(max=11) | ○ |
| C-08 | 非管理者は自部門のみ選択可能 | E-02 行61-64 | ○ |
| C-09 | 部門名は同一親部門内で一意 | E-03 行300-301, E-05 行69-72 | ○ |
| C-10 | 親部門が停用状態の場合は登録不可 | E-03 行197-200 | ○ |
| C-11 | ancestorsは親部門のancestors + parentId | E-03 行201 | ○ |
| C-12 | system:dept:add権限が必要 | E-02 行57 @RequiresPermissions | ○ |
| C-13 | 状態はsys_normal_disable辞書から取得 | E-01 行52 @dict.getType | ○ |
| C-14 | 親部門選択時にtree.htmlが開く | E-01 行116 | ○ |
| C-15 | sys_deptテーブルにINSERT | E-05 行89-115 | ○ |
| C-16 | create_byにログインユーザー名設定 | E-02 行82 | ○ |
| C-17 | create_timeにsysdate()設定 | E-05 行113 | ○ |
| C-18 | del_flagのデフォルト値 | E-05 - 明示的記載なし | ○ |
| C-19 | 部門名重複時のエラーメッセージ | E-01 行93-95 | ○ |
| C-20 | サーバー側重複エラーメッセージ | E-02 行80 | ○ |
| C-21 | 部門停用エラーメッセージ | E-03 行199 | ○ |
| C-22 | フォームID form-dept-add | E-01 行8 | ○ |
| C-23 | jQuery Validateによるバリデーション | E-01 行64-98 | ○ |
| C-24 | 表示順序は数値のみ(digits:true) | E-01 行82-84 | ○ |
| C-25 | メール形式チェック(email:true) | E-01 行85-87 | ○ |
| C-26 | 電話番号形式チェック(isPhone:true) | E-01 行88-90 | △ |
| C-27 | メッセージIDの体系（MSG001等） | **根拠なし** | △ |
| C-28 | 関連機能No.4 部門管理 | E-06 行52 | ○ |

## 4) 不足情報（Unknown / Missing）
- メッセージIDの体系は設計書独自に定義したものであり、実際のシステムではメッセージIDを使用していない可能性がある
  - 候補：i18nプロパティファイル / メッセージ管理テーブル / 未定義
- isPhoneカスタムバリデータの実装詳細
  - 候補：ruoyi.jsのカスタムバリデーションメソッド / jQuery Validate拡張

## 5) リスクフラグ（レビュー観点）
- 0: メッセージID体系の確認（実運用への影響なし）
- 0: isPhoneバリデータの動作確認（機能的には動作する）

## 6) レビュアーチェックリスト（最小）
- [ ] 部門名30文字制限がUI/サーバー両方で適用されているか確認
- [ ] 非管理者の親部門制限が意図通り動作するか確認
- [ ] 親部門停用時のエラーハンドリングが適切か確認
- [ ] ancestors構築ロジックが階層深度に依存しないか確認
