---
generated_at: 2026-01-08 10:35:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：32-部門編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **メッセージIDの体系**：設計書独自の定義

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/dept/edit.html` - 画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java` - コントローラー
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java` - サービス実装
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` - エンティティ
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysDeptMapper.xml` - SQLマッパー
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは GET /system/dept/edit/{deptId} | E-02 行90 | ○ |
| C-02 | 更新処理は POST /system/dept/edit | E-02 行108 | ○ |
| C-03 | system:dept:edit権限が必要 | E-02 行89 @RequiresPermissions | ○ |
| C-04 | データスコープチェックが実行される | E-02 行93, E-03 行313-326 | ○ |
| C-05 | ルート部門(100)の親部門名は「無」 | E-02 行95-98 | ○ |
| C-06 | 自部門を親に設定不可 | E-02 行118-121 | ○ |
| C-07 | 停用時に正常な子部門がある場合エラー | E-02 行122-125 | ○ |
| C-08 | 親部門変更時ancestorsを再構築 | E-03 行215-222 | ○ |
| C-09 | 配下部門のancestorsを一括更新 | E-03 行253-264 | ○ |
| C-10 | 正常状態変更時に祖先も正常化 | E-03 行225-230 | ○ |
| C-11 | excludeIdで自部門と配下を除外 | E-01 行118, E-03 行71-79 | ○ |
| C-12 | 部門名の一意性チェック | E-02 行114, E-01 行68-85 | ○ |
| C-13 | th:fieldで既存値をバインド | E-01 行23, 29等 | ○ |
| C-14 | updateDept UPDATE文 | E-05 行117-132 | ○ |
| C-15 | updateDeptChildren UPDATE文 | E-05 行134-145 | ○ |
| C-16 | updateDeptStatusNormal UPDATE文 | E-05 行151-156 | ○ |
| C-17 | update_byにログインユーザー名設定 | E-02 行126 | ○ |
| C-18 | update_timeにsysdate()設定 | E-05 行129 | ○ |
| C-19 | 部門名重複エラーメッセージ | E-02 行116 | ○ |
| C-20 | 自己参照エラーメッセージ | E-02 行120 | ○ |
| C-21 | 子部門状態エラーメッセージ | E-02 行124 | ○ |
| C-22 | 父部門不能選択エラー | E-01 行123 | ○ |
| C-23 | データスコープエラーメッセージ | E-03 行323 | ○ |
| C-24 | フォームID form-dept-edit | E-01 行8 | ○ |
| C-25 | deptIdをhiddenで保持 | E-01 行9 | ○ |
| C-26 | parentIdをhiddenで保持 | E-01 行10 | ○ |
| C-27 | 関連機能No.4 部門管理 | E-06 行53 | ○ |
| C-28 | @Transactionalでトランザクション管理 | E-03 行212 | ○ |
| C-29 | $.tree.notAllowLastLevelでレベルチェック | E-01 行129 | ○ |
| C-30 | メッセージIDの体系（MSG001等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージIDは設計書独自の定義であり、実システムとの対応確認が必要
  - 候補：i18nプロパティファイル / コード内ハードコーディング

## 5) リスクフラグ（レビュー観点）
- 0: メッセージID体系（実運用影響なし）

## 6) レビュアーチェックリスト（最小）
- [ ] 親部門変更時のancestors更新が正しく動作するか確認
- [ ] 大規模組織での配下部門一括更新のパフォーマンス確認
- [ ] 正常状態への変更時の祖先部門更新が意図通りか確認
