---
generated_at: 2026-01-08 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-部門ツリー選択

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべてのClaimに根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/dept/tree.html` - 画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java` - コントローラー
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java` - サービス実装
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは /system/dept/selectDeptTree/{deptId} | E-02 行168 | ○ |
| C-02 | excludeIdで配下を除外 | E-02 行168, E-03 行73-76 | ○ |
| C-03 | ツリーデータURLは /system/dept/treeData/{excludeId} | E-02 行180 | ○ |
| C-04 | system:dept:list権限が必要 | E-02 行167, 179 | ○ |
| C-05 | treeId, treeNameをhiddenで保持 | E-01 行12-13 | ○ |
| C-06 | expandLevel: 2 | E-01 行38 | ○ |
| C-07 | zOnClickでノード選択処理 | E-01 行39, 44-49 | ○ |
| C-08 | treeNode.idから部門ID取得 | E-01 行45 | ○ |
| C-09 | treeNode.nameから部門名取得 | E-01 行46 | ○ |
| C-10 | $.tree.searchNode()で検索 | E-01 行21 | ○ |
| C-11 | $.tree.expand()で展開 | E-01 行23 | ○ |
| C-12 | $.tree.collapse()で折りたたみ | E-01 行24 | ○ |
| C-13 | $.tree.toggleSearch()で検索表示切替 | E-01 行14 | ○ |
| C-14 | initZtreeでZtreeリスト生成 | E-03 行111-145 | ○ |
| C-15 | 停用部門は除外 | E-03 行130 DEPT_NORMAL条件 | ○ |
| C-16 | ancestors.containsでフィルタ | E-03 行75 | ○ |
| C-17 | Ztreeにid,pId,name,title設定 | E-03 行133-136 | ○ |
| C-18 | selectDeptListでDB参照 | E-03 行72 | ○ |
| C-19 | @DataScopeでデータ範囲制限 | E-03 行68 | ○ |
| C-20 | ztree-cssインクルード | E-01 行5 | ○ |
| C-21 | ztree-jsインクルード | E-01 行29 | ○ |
| C-22 | 関連機能No.4 部門管理 | E-04 行54 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 本画面は参照専用であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] excludeIdによる配下除外が正しく動作するか確認
- [ ] データスコープによるフィルタリングが意図通りか確認
- [ ] 大量部門時のツリー描画パフォーマンス確認
