---
generated_at: 2026-01-08 10:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：34-岗位管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **メッセージIDの体系**：設計書独自の定義

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/post/post.html` - 画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` - コントローラー
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` - エンティティ
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysPostMapper.xml` - SQLマッパー
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは GET /system/post | E-02 行38 | ○ |
| C-02 | 一覧取得は POST /system/post/list | E-02 行45 | ○ |
| C-03 | system:post:view権限で画面表示 | E-02 行37 | ○ |
| C-04 | system:post:add権限で新規ボタン | E-01 行35 | ○ |
| C-05 | system:post:edit権限で編集ボタン | E-01 行38 | ○ |
| C-06 | system:post:remove権限で削除ボタン | E-01 行41 | ○ |
| C-07 | system:post:export権限でエクスポート | E-01 行44 | ○ |
| C-08 | postCodeで部分一致検索 | E-04 行29 LIKE | ○ |
| C-09 | postNameで部分一致検索 | E-04 行35 LIKE | ○ |
| C-10 | statusで完全一致検索 | E-04 行32 | ○ |
| C-11 | デフォルトソートはpostSort | E-01 行68 sortName | ○ |
| C-12 | postCode列はソート可能 | E-01 行80 sortable | ○ |
| C-13 | postName列はソート可能 | E-01 行85 sortable | ○ |
| C-14 | postSort列はソート可能 | E-01 行90 sortable | ○ |
| C-15 | createTime列はソート可能 | E-01 行103 sortable | ○ |
| C-16 | status列はsys_normal_disable辞書で変換 | E-01 行96-98 | ○ |
| C-17 | 削除は物理削除 | E-04 行67-72 DELETE | ○ |
| C-18 | エクスポートはExcelUtil使用 | E-02 行61-62 | ○ |
| C-19 | @Excelでエクスポート列定義 | E-03 行20-36 | ○ |
| C-20 | startPage()でページング設定 | E-02 行49 | ○ |
| C-21 | $.table.search()で検索 | E-01 行26 | ○ |
| C-22 | $.form.reset()でリセット | E-01 行27 | ○ |
| C-23 | $.operate.add()で新規画面 | E-01 行35 | ○ |
| C-24 | $.operate.edit()で編集画面 | E-01 行110 | ○ |
| C-25 | 関連機能No.5 役職管理 | E-05 行55-56 | ○ |
| C-26 | メッセージIDの体系 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージIDは設計書独自の定義
  - 候補：i18nプロパティファイル / フロントエンドJS定義

## 5) リスクフラグ（レビュー観点）
- 0: メッセージID体系（実運用影響なし）

## 6) レビュアーチェックリスト（最小）
- [ ] 物理削除が業務要件に合致しているか確認
- [ ] ユーザー割当済み岗位の削除防止が正しく動作するか確認
- [ ] エクスポート時の文字コード・フォーマットが適切か確認
