---
generated_at: 2026-01-08 10:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：35-岗位新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **メッセージIDの体系**：設計書独自の定義

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/post/add.html` - 画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` - コントローラー
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` - エンティティ
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysPostMapper.xml` - SQLマッパー
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは GET /system/post/add | E-02 行78 | ○ |
| C-02 | 登録処理は POST /system/post/add | E-02 行89 | ○ |
| C-03 | system:post:add権限が必要 | E-02 行77, 87 | ○ |
| C-04 | postNameは50文字以内 | E-03 行65 @Size(max=50) | ○ |
| C-05 | postCodeは64文字以内 | E-03 行53 @Size(max=64) | ○ |
| C-06 | postNameは必須 | E-03 行64 @NotBlank | ○ |
| C-07 | postCodeは必須 | E-03 行52 @NotBlank | ○ |
| C-08 | postSortは必須 | E-03 行76 @NotBlank | ○ |
| C-09 | checkPostNameUnique URL | E-02 行140, E-01 行53 | ○ |
| C-10 | checkPostCodeUnique URL | E-02 行150, E-01 行65 | ○ |
| C-11 | 名称重複時のクライアントエラー | E-01 行83-85 | ○ |
| C-12 | 編碼重複時のクライアントエラー | E-01 行80-82 | ○ |
| C-13 | サーバー側名称重複チェック | E-02 行93-96 | ○ |
| C-14 | サーバー側編碼重複チェック | E-02 行97-100 | ○ |
| C-15 | create_byにログインユーザー設定 | E-02 行101 | ○ |
| C-16 | useGeneratedKeysでID自動採番 | E-04 行88 | ○ |
| C-17 | create_timeにsysdate()設定 | E-04 行106 | ○ |
| C-18 | フォームID form-post-add | E-01 行8 | ○ |
| C-19 | 状態はsys_normal_disable辞書 | E-01 行30-33 | ○ |
| C-20 | 表示順序は数値チェック | E-01 行75-77 digits:true | ○ |
| C-21 | 備考はtextarea | E-01 行39 | ○ |
| C-22 | $.operate.saveで登録 | E-01 行92 | ○ |
| C-23 | 関連機能No.5 役職管理 | E-05 行57 | ○ |
| C-24 | メッセージIDの体系 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージIDは設計書独自の定義
  - 候補：i18nプロパティファイル / コード内ハードコーディング

## 5) リスクフラグ（レビュー観点）
- 0: メッセージID体系（実運用影響なし）

## 6) レビュアーチェックリスト（最小）
- [ ] 岗位編碼・名称の一意性がUI/サーバー両方で適用されているか確認
- [ ] 表示順序の数値バリデーションが正しく動作するか確認
