---
generated_at: 2026-01-08 10:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：36-岗位編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **メッセージIDの体系**：設計書独自の定義

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/post/edit.html` - 画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` - コントローラー
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` - エンティティ
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysPostMapper.xml` - SQLマッパー
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは GET /system/post/edit/{postId} | E-02 行109 | ○ |
| C-02 | 更新処理は POST /system/post/edit | E-02 行121 | ○ |
| C-03 | system:post:edit権限が必要 | E-02 行108, 119 | ○ |
| C-04 | postIdをhiddenで保持 | E-01 行9 | ○ |
| C-05 | th:fieldで既存値をバインド | E-01 行13, 19, 25等 | ○ |
| C-06 | 一意性チェックにpostIdを含める | E-01 行58-60, 73-75 | ○ |
| C-07 | サーバー側名称重複チェック | E-02 行125-128 | ○ |
| C-08 | サーバー側編碼重複チェック | E-02 行129-132 | ○ |
| C-09 | update_byにログインユーザー設定 | E-02 行133 | ○ |
| C-10 | update_timeにsysdate()設定 | E-04 行83 | ○ |
| C-11 | updatePost UPDATE文 | E-04 行74-86 | ○ |
| C-12 | フォームID form-post-edit | E-01 行8 | ○ |
| C-13 | 状態はsys_normal_disable辞書 | E-01 行31-34 | ○ |
| C-14 | 表示順序は数値チェック | E-01 行81-83 digits:true | ○ |
| C-15 | 備考の既存値表示 | E-01 行40 [[*{remark}]] | ○ |
| C-16 | $.operate.saveで更新 | E-01 行99 | ○ |
| C-17 | 名称重複エラーメッセージ | E-01 行90-92 | ○ |
| C-18 | 編碼重複エラーメッセージ | E-01 行87-89 | ○ |
| C-19 | サーバー側名称エラー | E-02 行127 | ○ |
| C-20 | サーバー側編碼エラー | E-02 行131 | ○ |
| C-21 | selectPostByIdで既存データ取得 | E-02 行112 | ○ |
| C-22 | post_sortの更新 | E-04 行79 | ○ |
| C-23 | 関連機能No.5 役職管理 | E-05 行58 | ○ |
| C-24 | メッセージIDの体系 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージIDは設計書独自の定義
  - 候補：i18nプロパティファイル / コード内ハードコーディング

## 5) リスクフラグ（レビュー観点）
- 0: メッセージID体系（実運用影響なし）

## 6) レビュアーチェックリスト（最小）
- [ ] 自身を除外した一意性チェックが正しく動作するか確認
- [ ] 既存値のバインディングが正しく表示されるか確認
