---
generated_at: 2026-01-08 11:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：37-字典類型管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **メッセージIDの体系**：設計書独自の定義

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/dict/type/type.html` - 画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` - コントローラー
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` - エンティティ
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysDictTypeMapper.xml` - SQLマッパー
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは GET /system/dict | E-02 行39 | ○ |
| C-02 | 一覧取得は POST /system/dict/list | E-02 行46 | ○ |
| C-03 | system:dict:view権限で画面表示 | E-02 行38 | ○ |
| C-04 | system:dict:add権限で新規ボタン | E-01 行41 | ○ |
| C-05 | system:dict:edit権限で編集ボタン | E-01 行44 | ○ |
| C-06 | system:dict:remove権限で削除ボタン | E-01 行47, 53 | ○ |
| C-07 | system:dict:export権限でエクスポート | E-01 行50 | ○ |
| C-08 | system:dict:list権限で列表ボタン | E-01 行66 | ○ |
| C-09 | dictNameで部分一致検索 | E-04 行27 LIKE | ○ |
| C-10 | dictTypeで部分一致検索 | E-04 行33 LIKE | ○ |
| C-11 | 日時範囲検索 | E-04 行35-40 | ○ |
| C-12 | デフォルトソートはdictId昇順 | E-01 行78-79 | ○ |
| C-13 | dictName列はソート可能 | E-01 行91 | ○ |
| C-14 | dictType列はリンク付き | E-01 行96-99 | ○ |
| C-15 | 備考列はtooltip表示 | E-01 行112-114 | ○ |
| C-16 | detail関数でタブ遷移 | E-01 行137-140 $.modal.openTab | ○ |
| C-17 | refreshCache URL | E-02 行137 | ○ |
| C-18 | refreshCache権限 | E-02 行135 | ○ |
| C-19 | dictTypeService.resetDictCache() | E-02 行141 | ○ |
| C-20 | 削除は物理削除 | E-04 行63-72 DELETE | ○ |
| C-21 | @Excelでエクスポート列定義 | E-03 行20-32 | ○ |
| C-22 | status列はsys_normal_disable辞書 | E-01 行103-107 | ○ |
| C-23 | createTime列はソート可能 | E-01 行119 | ○ |
| C-24 | 関連機能No.8 辞書タイプ管理 | E-05 行59-60 | ○ |
| C-25 | detail画面URL | E-02 行150 | ○ |
| C-26 | selectDictTypeAll呼び出し | E-02 行153 | ○ |
| C-27 | $.operate.getでrefreshCache呼び出し | E-01 行144 | ○ |
| C-28 | メッセージIDの体系 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージIDは設計書独自の定義
  - 候補：i18nプロパティファイル / フロントエンドJS定義

## 5) リスクフラグ（レビュー観点）
- 0: メッセージID体系（実運用影響なし）

## 6) レビュアーチェックリスト（最小）
- [ ] キャッシュリフレッシュ機能が正しく動作するか確認
- [ ] 字典データ画面への遷移が正しく動作するか確認
- [ ] 削除時に関連する字典データの処理が適切か確認
