---
generated_at: 2026-01-08 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：38-字典類型新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **メッセージIDの体系**：設計書独自の定義

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/dict/type/add.html` - 画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` - コントローラー
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` - エンティティ
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysDictTypeMapper.xml` - SQLマッパー
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは GET /system/dict/add | E-02 行71 | ○ |
| C-02 | 登録処理は POST /system/dict/add | E-02 行82 | ○ |
| C-03 | system:dict:add権限が必要 | E-02 行70, 81 | ○ |
| C-04 | dictNameは100文字以内 | E-03 行46 @Size(max=100) | ○ |
| C-05 | dictTypeは100文字以内 | E-03 行58 @Size(max=100) | ○ |
| C-06 | dictNameは必須 | E-03 行45 @NotBlank | ○ |
| C-07 | dictTypeは必須 | E-03 行57 @NotBlank | ○ |
| C-08 | dictType形式はPattern | E-03 行59 @Pattern | ○ |
| C-09 | 最小5文字チェック | E-01 行47 minlength: 5 | ○ |
| C-10 | checkDictTypeUnique URL | E-02 行161, E-01 行49 | ○ |
| C-11 | 一意性チェックのremote設定 | E-01 行48-56 | ○ |
| C-12 | サーバー側一意性チェック | E-02 行86-89 | ○ |
| C-13 | create_byにログインユーザー設定 | E-02 行90 | ○ |
| C-14 | create_timeにsysdate()設定 | E-04 行101 | ○ |
| C-15 | フォームID form-dict-add | E-01 行8 | ○ |
| C-16 | 状態はsys_normal_disable辞書 | E-01 行25-28 | ○ |
| C-17 | ヘルプテキスト表示 | E-01 行19 | ○ |
| C-18 | $.operate.saveで登録 | E-01 行70 | ○ |
| C-19 | 重複時エラーメッセージ | E-01 行61-63 | ○ |
| C-20 | サーバー側エラーメッセージ | E-02 行88 | ○ |
| C-21 | 関連機能No.8 辞書タイプ管理 | E-05 行61 | ○ |
| C-22 | メッセージIDの体系 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージIDは設計書独自の定義
  - 候補：i18nプロパティファイル / コード内ハードコーディング

## 5) リスクフラグ（レビュー観点）
- 0: メッセージID体系（実運用影響なし）

## 6) レビュアーチェックリスト（最小）
- [ ] 字典類型の形式バリデーション（^[a-z][a-z0-9_]*$）が正しく動作するか確認
- [ ] 最小5文字チェックがUI/サーバー両方で適用されているか確認
