---
generated_at: 2026-01-08 10:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-システム首頁

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/index.html` - システム首頁テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` - インデックスコントローラー
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | システム首頁のURLは `/index` | E-02 (48行目 @GetMapping("/index")) | ○ |
| C-02 | 左側にサイドバーメニュー表示 | E-01 (23-186行目 navbar-static-side) | ○ |
| C-03 | 右側にiframeコンテンツ領域 | E-01 (251-254行目 iframe class="RuoYi_iframe") | ○ |
| C-04 | ユーザーアバター表示 | E-01 (39行目, 204行目 th:src user.avatar) | ○ |
| C-05 | ユーザー名表示 | E-01 (43行目 user.loginName) | ○ |
| C-06 | メニューは権限に基づき動的生成 | E-02 (54行目 menuService.selectMenusByUser) | ○ |
| C-07 | タブバーによるマルチウィンドウ | E-01 (234-247行目 page-tabs menuTabs) | ○ |
| C-08 | ドロップダウンメニュー（個人中心等） | E-01 (207-229行目 dropdown-menu) | ○ |
| C-09 | 「锁屏」アイコンが存在 | E-01 (200行目 lockScreen) | ○ |
| C-10 | 「全屏」アイコンが存在 | E-01 (201行目 fullScreen) | ○ |
| C-11 | 「文档」リンクが存在 | E-01 (199行目 doc.ruoyi.vip) | ○ |
| C-12 | メニュースタイル切替機能 | E-02 (126-130行目 /system/menuStyle/{style}) | ○ |
| C-13 | テーマ切替機能 | E-02 (119-123行目 /system/switchSkin) | ○ |
| C-14 | Cookie/設定によるメニュースタイル判定 | E-02 (71-88行目 Cookie nav-style) | ○ |
| C-15 | 初期パスワード変更促進 | E-01 (364-374行目 isDefaultModifyPwd), E-02 (159-162行目) | ○ |
| C-16 | パスワード有効期限警告 | E-01 (377-387行目 isPasswordExpired), E-02 (166-179行目) | ○ |
| C-17 | フッター表示設定 | E-01 (256-258行目 th:if footer), E-02 (59-61行目) | ○ |
| C-18 | タグビュー表示設定 | E-01 (234行目 th:classappend tagsView), E-02 (60行目) | ○ |
| C-19 | モバイル判定によるレイアウト調整 | E-01 (19行目 isMobile canvas-menu), E-02 (68行目) | ○ |
| C-20 | スキン設定のローカルストレージ保存 | E-01 (280-297行目 storage.get("skin")) | ○ |
| C-21 | 機能No.19「ログイン」がAPI連携 | E-03 (8行目) | ○ |
| C-22 | メインカテゴリは「メイン」 | E-04 (5行目) | ○ |
| C-23 | テンプレートファイルパスはindex.html | E-04 (5行目) | ○ |
| C-24 | 画面遷移：ログイン→システム首頁 | E-05 (49行目 Login --> Index) | ○ |
| C-25 | 画面遷移：システム首頁→画面ロック | E-05 (52行目 Index --> Lock) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] メニュー4階層表示の動作確認
- [ ] タブ右クリックコンテキストメニューの動作確認
- [ ] モバイルデバイスでのレイアウト確認
