---
generated_at: 2026-01-08 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：40-字典類型ツリー表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **呼び出し元画面の特定**：本画面を呼び出す具体的な画面の記載なし

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/dict/type/tree.html` - 画面テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java` - コントローラー
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictTypeServiceImpl.java` - サービス実装
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java` - Ztreeエンティティ
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは GET /system/dict/selectDictTree/{columnId}/{dictType} | E-02 行170 | ○ |
| C-02 | ツリーデータ取得URLは GET /system/dict/treeData | E-02 行181, E-01 行29 | ○ |
| C-03 | hidden項目columnId, treeId, dictTypeを保持 | E-01 行12-14 | ○ |
| C-04 | キーワード検索欄（最大50文字） | E-01 行20 maxlength="50" | ○ |
| C-05 | $.tree.init()でツリー初期化 | E-01 行34 | ○ |
| C-06 | zOnClickでノードクリック処理 | E-01 行32, 37-39 | ○ |
| C-07 | クリック時にtreeNode.titleをdictTypeに設定 | E-01 行38 | ○ |
| C-08 | $.tree.searchNode()で検索 | E-01 行21 | ○ |
| C-09 | $.tree.toggleSearch()で検索欄表示切替 | E-01 行15 | ○ |
| C-10 | selectDictTypeByTypeで初期値取得 | E-02 行174 | ○ |
| C-11 | selectDictTreeでZtree変換 | E-03 行235-251 | ○ |
| C-12 | 正常状態（status='0'）のみフィルタ | E-03 行241 | ○ |
| C-13 | Ztree.id = dictId | E-03 行244 | ○ |
| C-14 | Ztree.name = transDictName | E-03 行245 | ○ |
| C-15 | Ztree.title = dictType | E-03 行246 | ○ |
| C-16 | transDictNameは「(dictName) dictType」形式 | E-03 行253-258 | ○ |
| C-17 | 関連機能No.8 辞書タイプ管理 | E-05 行63 | ○ |
| C-18 | 呼び出し元画面の権限に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 本画面を呼び出す具体的な画面の特定
  - 候補：コード生成画面 / 他の字典選択が必要な画面
- 権限制御の詳細
  - 候補：呼び出し元画面の実装確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 呼び出し元画面の権限依存（実装影響なし）

## 6) レビュアーチェックリスト（最小）
- [ ] ztree.jsライブラリが正しく読み込まれているか確認
- [ ] 検索機能（$.tree.searchNode）が期待通り動作するか確認
- [ ] ノード選択時に呼び出し元画面への値反映が正しく動作するか確認
