---
generated_at: 2026-01-08 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：41-字典データ管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **メッセージID定義**：メッセージIDの具体値が未確認
  2. **機能No対応**：画面機能マッピングCSVとの整合性確認推奨
  3. **権限名称**：Shiro権限文字列の正確性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/dict/data/data.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java`
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysDictDataMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/dict/data | E-02 (37-42行目) | ○ |
| C-02 | 一覧取得API: POST /system/dict/data/list | E-02 (44-52行目) | ○ |
| C-03 | 削除API: POST /system/dict/data/remove | E-02 (113-121行目) | ○ |
| C-04 | エクスポートAPI: POST /system/dict/data/export | E-02 (54-63行目) | ○ |
| C-05 | 権限制御: system:dict:add | E-01 (38行目), E-02 (68-80行目) | ○ |
| C-06 | 権限制御: system:dict:edit | E-01 (41行目), E-02 (92-98行目) | ○ |
| C-07 | 権限制御: system:dict:remove | E-01 (44行目), E-02 (113-121行目) | ○ |
| C-08 | 権限制御: system:dict:export | E-01 (47行目), E-02 (54-63行目) | ○ |
| C-09 | 検索条件: dictType | E-01 (15-18行目), E-04 (31-33行目) | ○ |
| C-10 | 検索条件: dictLabel（部分一致） | E-01 (20行目), E-04 (34-36行目) | ○ |
| C-11 | 検索条件: status | E-01 (22-26行目), E-04 (37-39行目) | ○ |
| C-12 | 一覧カラム: dictCode | E-01 (82-85行目), E-03 | ○ |
| C-13 | 一覧カラム: dictLabel（スタイル適用） | E-01 (86-94行目) | ○ |
| C-14 | 一覧カラム: dictValue | E-01 (95-98行目) | ○ |
| C-15 | 一覧カラム: dictSort | E-01 (99-102行目) | ○ |
| C-16 | 一覧カラム: status（辞書変換） | E-01 (103-110行目) | ○ |
| C-17 | 一覧カラム: remark | E-01 (111-114行目) | ○ |
| C-18 | 一覧カラム: createTime | E-01 (115-119行目) | ○ |
| C-19 | デフォルトソート: dictSort昇順 | E-01 (76-77行目) | ○ |
| C-20 | 対象テーブル: sys_dict_data | E-04 (25行目) | ○ |
| C-21 | キャッシュ更新: DictUtils.setDictCache | E-05 (74行目) | ○ |
| C-22 | 機能No: 9（辞書データ管理） | E-06 (64行目) | ○ |
| C-23 | 機能No: 24（ファイルダウンロード） | E-06 (65行目) | ○ |
| C-24 | 画面遷移: 字典類型管理一覧から遷移 | E-07 (字典管理フロー) | ○ |
| C-25 | メッセージID定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージIDの具体的な定義値が不明
  - 候補：i18n設定ファイル / messages.properties / JavaScript内定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URLマッピング、カラム定義は確実に検証済み
- 0: 低リスク - 権限制御の記述は複数ソースで確認
- 1: 中リスク - メッセージ仕様は実際の動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 画面表示URLが正しくアクセス可能か確認
- [ ] 権限のないユーザーでボタン非表示を確認
- [ ] 削除時の確認ダイアログメッセージを確認
- [ ] Excelエクスポートが正常に動作するか確認
- [ ] キャッシュ更新が削除後に反映されるか確認
