---
generated_at: 2026-01-08 12:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-字典データ新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **バリデーションメッセージ**：実際の画面表示で確認推奨
  2. **キャッシュ更新タイミング**：登録後の即時反映を確認
  3. **モーダルウィンドウ動作**：$.operate.save()の挙動確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/dict/data/add.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java`
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysDictDataMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/dict/data/add/{dictType} | E-02 (68-74行目) | ○ |
| C-02 | 登録API: POST /system/dict/data/add | E-02 (78-87行目), E-01 (95行目) | ○ |
| C-03 | 権限制御: system:dict:add | E-02 (68,80行目) | ○ |
| C-04 | 入力項目: dictLabel（必須、100文字） | E-01 (10-13行目), E-03 (75-76行目) | ○ |
| C-05 | 入力項目: dictValue（必須、100文字） | E-01 (15-19行目), E-03 (87-88行目) | ○ |
| C-06 | 入力項目: dictType（読み取り専用） | E-01 (22-25行目) | ○ |
| C-07 | 入力項目: cssClass | E-01 (28-31行目) | ○ |
| C-08 | 入力項目: dictSort（必須、整数） | E-01 (33-37行目), E-01 (86-88行目) | ○ |
| C-09 | 入力項目: listClass（選択肢6種） | E-01 (40-52行目) | ○ |
| C-10 | 入力項目: isDefault（Y/N） | E-01 (54-61行目) | ○ |
| C-11 | 入力項目: status（0/1） | E-01 (63-70行目) | ○ |
| C-12 | 入力項目: remark | E-01 (72-76行目) | ○ |
| C-13 | バリデーション: dictSort整数チェック | E-01 (85-89行目) | ○ |
| C-14 | 送信処理: submitHandler | E-01 (93-97行目) | ○ |
| C-15 | INSERT文: dict_sort含む全カラム | E-04 (95-121行目) | ○ |
| C-16 | createBy設定: getLoginName() | E-02 (85行目) | ○ |
| C-17 | create_time: sysdate() | E-04 (119行目) | ○ |
| C-18 | キャッシュ更新: DictUtils.setDictCache | E-05 (91行目) | ○ |
| C-19 | 機能No: 9（辞書データ管理） | E-06 (66行目) | ○ |
| C-20 | URLパラメータからdictType取得 | E-02 (70,72行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入力項目定義は確実に検証済み
- 0: 低リスク - INSERT文のカラム対応は確実
- 0: 低リスク - バリデーションルールは実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各入力項目の必須チェックが動作するか確認
- [ ] dictSort非整数入力時のエラー表示を確認
- [ ] 登録後に一覧画面が正しく更新されるか確認
- [ ] 字典類型が読み取り専用になっているか確認
- [ ] 回显様式選択後、一覧でスタイルが反映されるか確認
