---
generated_at: 2026-01-08 12:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-字典データ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **dictValue変更影響**：既存データへの影響確認
  2. **楽観的ロック**：同時更新時の挙動確認
  3. **キャッシュ更新**：更新後の即時反映確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/dict/data/edit.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java`
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysDictDataMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/dict/data/edit/{dictCode} | E-02 (92-98行目) | ○ |
| C-02 | 更新API: POST /system/dict/data/edit | E-02 (103-111行目), E-01 (96行目) | ○ |
| C-03 | 権限制御: system:dict:edit | E-02 (92,104行目) | ○ |
| C-04 | 入力項目: dictCode（hidden） | E-01 (9行目) | ○ |
| C-05 | 入力項目: dictLabel（既存値表示） | E-01 (11-14行目) | ○ |
| C-06 | 入力項目: dictValue（既存値表示） | E-01 (16-20行目) | ○ |
| C-07 | 入力項目: dictType（読み取り専用） | E-01 (22-26行目) | ○ |
| C-08 | 入力項目: cssClass | E-01 (28-32行目) | ○ |
| C-09 | 入力項目: dictSort（既存値表示） | E-01 (34-38行目) | ○ |
| C-10 | 入力項目: listClass（選択肢、既存値選択） | E-01 (40-53行目) | ○ |
| C-11 | 入力項目: isDefault（既存値選択） | E-01 (55-62行目) | ○ |
| C-12 | 入力項目: status（既存値選択） | E-01 (64-71行目) | ○ |
| C-13 | 入力項目: remark（既存値表示） | E-01 (73-77行目) | ○ |
| C-14 | th:objectでエンティティバインド | E-01 (8行目) | ○ |
| C-15 | バリデーション: dictSort整数チェック | E-01 (85-91行目) | ○ |
| C-16 | submitHandler定義 | E-01 (94-98行目) | ○ |
| C-17 | UPDATE文: WHERE dict_code | E-04 (73-89行目) | ○ |
| C-18 | updateBy設定: getLoginName() | E-02 (109行目) | ○ |
| C-19 | update_time: sysdate() | E-04 (86行目) | ○ |
| C-20 | キャッシュ更新: DictUtils.setDictCache | E-05 (109行目) | ○ |
| C-21 | 機能No: 9（辞書データ管理） | E-06 (67行目) | ○ |
| C-22 | データ取得: selectDictDataById | E-02 (96行目), E-05 (54-58行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面項目と更新カラムの対応は確実
- 0: 低リスク - バリデーションルールは新規登録と同一
- 1: 中リスク - 同時更新時の楽観的ロック機能なし

## 6) レビュアーチェックリスト（最小）
- [ ] 既存データが正しく初期表示されるか確認
- [ ] dictTypeが編集不可になっているか確認
- [ ] 更新後に一覧画面が正しく更新されるか確認
- [ ] 回显様式変更後、一覧でスタイルが反映されるか確認
- [ ] dictValue変更時、既存データへの影響有無を確認
