---
generated_at: 2026-01-08 12:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-パラメータ管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. **システム内置削除保護**：実際の動作確認推奨
  2. **キャッシュ刷新タイミング**：刷新後の即時反映を確認
  3. **日付範囲検索**：日付フォーマットの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/config/config.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysConfigMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/config | E-02 (37-42行目) | ○ |
| C-02 | 一覧API: POST /system/config/list | E-02 (47-55行目) | ○ |
| C-03 | 削除API: POST /system/config/remove | E-02 (126-134行目) | ○ |
| C-04 | エクスポートAPI: POST /system/config/export | E-02 (57-66行目) | ○ |
| C-05 | キャッシュ刷新API: GET /system/config/refreshCache | E-02 (139-147行目) | ○ |
| C-06 | 権限制御: system:config:add | E-01 (41行目), E-02 (71行目) | ○ |
| C-07 | 権限制御: system:config:edit | E-01 (44行目), E-02 (98行目) | ○ |
| C-08 | 権限制御: system:config:remove | E-01 (47,53行目), E-02 (126行目) | ○ |
| C-09 | 権限制御: system:config:export | E-01 (50行目), E-02 (58行目) | ○ |
| C-10 | 検索条件: configName（部分一致） | E-01 (14行目), E-04 (44-46行目) | ○ |
| C-11 | 検索条件: configKey（部分一致） | E-01 (17行目), E-04 (50-52行目) | ○ |
| C-12 | 検索条件: configType | E-01 (19-23行目), E-04 (47-49行目) | ○ |
| C-13 | 検索条件: 日付範囲 | E-01 (25-29行目), E-04 (53-58行目) | ○ |
| C-14 | 一覧カラム: configId | E-01 (82-85行目) | ○ |
| C-15 | 一覧カラム: configName（ツールチップ） | E-01 (86-92行目) | ○ |
| C-16 | 一覧カラム: configKey（ツールチップ） | E-01 (93-99行目) | ○ |
| C-17 | 一覧カラム: configValue（ツールチップ） | E-01 (100-107行目) | ○ |
| C-18 | 一覧カラム: configType（辞書変換） | E-01 (108-115行目) | ○ |
| C-19 | 一覧カラム: remark（ツールチップ） | E-01 (116-123行目) | ○ |
| C-20 | 一覧カラム: createTime | E-01 (124-127行目) | ○ |
| C-21 | デフォルトソート: configId昇順 | E-01 (76-77行目) | ○ |
| C-22 | 対象テーブル: sys_config | E-04 (21行目) | ○ |
| C-23 | システム内置削除保護 | E-05 (140-143行目) | ○ |
| C-24 | キャッシュ管理: @PostConstruct初期化 | E-05 (31-35行目) | ○ |
| C-25 | キャッシュ刷新: resetConfigCache | E-05 (174-179行目) | ○ |
| C-26 | 機能No: 7（パラメータ設定） | E-06 (68-69行目) | ○ |
| C-27 | 機能No: 24（ファイルダウンロード） | E-06 (69行目) | ○ |
| C-28 | refreshCache関数定義 | E-01 (142-145行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URLマッピング、カラム定義は確実に検証済み
- 0: 低リスク - 権限制御の記述は複数ソースで確認
- 0: 低リスク - システム内置削除保護はServiceで実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 画面表示URLが正しくアクセス可能か確認
- [ ] 権限のないユーザーでボタン非表示を確認
- [ ] システム内置パラメータの削除がブロックされるか確認
- [ ] キャッシュ刷新後、設定変更が即時反映されるか確認
- [ ] 日付範囲検索が正しく動作するか確認
- [ ] Excelエクスポートが正常に動作するか確認
