---
generated_at: 2026-01-08 12:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-パラメータ新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **鍵名重複チェック**：Ajax非同期処理の動作確認
  2. **キャッシュ追加**：登録後の即時反映を確認
  3. **モーダルウィンドウ動作**：$.operate.save()の挙動確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/config/add.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysConfigMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/config/add | E-02 (71-76行目) | ○ |
| C-02 | 登録API: POST /system/config/add | E-02 (81-93行目), E-01 (74行目) | ○ |
| C-03 | 重複チェックAPI: POST /system/config/checkConfigKeyUnique | E-02 (152-158行目) | ○ |
| C-04 | 権限制御: system:config:add | E-02 (71,81行目) | ○ |
| C-05 | 入力項目: configName（必須、100文字） | E-01 (10-13行目), E-03 (49-50行目) | ○ |
| C-06 | 入力項目: configKey（必須、100文字） | E-01 (15-18行目), E-03 (61-62行目) | ○ |
| C-07 | 入力項目: configValue（必須、500文字） | E-01 (20-24行目), E-03 (73-74行目) | ○ |
| C-08 | 入力項目: configType（Y/N） | E-01 (26-34行目) | ○ |
| C-09 | 入力項目: remark | E-01 (36-40行目) | ○ |
| C-10 | remote検証: configKey重複チェック | E-01 (50-67行目) | ○ |
| C-11 | remote検証エラーメッセージ | E-01 (65-67行目) | ○ |
| C-12 | バリデーション: onkeyup:false | E-01 (49行目) | ○ |
| C-13 | submitHandler定義 | E-01 (72-76行目) | ○ |
| C-14 | INSERT文: config_name含む全カラム | E-04 (72-90行目) | ○ |
| C-15 | createBy設定: getLoginName() | E-02 (91行目) | ○ |
| C-16 | create_time: sysdate() | E-04 (88行目) | ○ |
| C-17 | キャッシュ追加: CacheUtils.put | E-05 (100行目) | ○ |
| C-18 | 重複チェックSQL: checkConfigKeyUnique | E-04 (67-70行目) | ○ |
| C-19 | サーバーサイド重複チェック | E-02 (87-90行目) | ○ |
| C-20 | 機能No: 7（パラメータ設定） | E-06 (70行目) | ○ |
| C-21 | checkConfigKeyUnique実装 | E-05 (187-197行目) | ○ |
| C-22 | 初期値: configType=N | E-01 (31行目 th:checked) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入力項目定義は確実に検証済み
- 0: 低リスク - INSERT文のカラム対応は確実
- 0: 低リスク - 重複チェックはフロント・サーバー両方で実装

## 6) レビュアーチェックリスト（最小）
- [ ] 各入力項目の必須チェックが動作するか確認
- [ ] configKey重複時のエラー表示を確認
- [ ] 登録後に一覧画面が正しく更新されるか確認
- [ ] configType=Y設定時、削除保護対象になるか確認
- [ ] 登録後にキャッシュに追加されるか確認
