---
generated_at: 2026-01-08 12:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-パラメータ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. **鍵名変更時のキャッシュ処理**：旧キー削除→新キー登録の動作確認
  2. **重複チェック（自分除外）**：configId送信による自己除外確認
  3. **configKey変更影響**：システム内参照箇所への影響確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/config/edit.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysConfigMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/config/edit/{configId} | E-02 (98-104行目) | ○ |
| C-02 | 更新API: POST /system/config/edit | E-02 (109-121行目), E-01 (78行目) | ○ |
| C-03 | 重複チェックAPI（configId付き） | E-01 (58-64行目), E-02 (152-158行目) | ○ |
| C-04 | 権限制御: system:config:edit | E-02 (98,109行目) | ○ |
| C-05 | 入力項目: configId（hidden） | E-01 (9行目) | ○ |
| C-06 | 入力項目: configName（既存値表示） | E-01 (11-14行目) | ○ |
| C-07 | 入力項目: configKey（既存値表示） | E-01 (16-19行目) | ○ |
| C-08 | 入力項目: configValue（既存値表示） | E-01 (21-25行目) | ○ |
| C-09 | 入力項目: configType（既存値選択） | E-01 (27-35行目) | ○ |
| C-10 | 入力項目: remark（既存値表示） | E-01 (37-41行目) | ○ |
| C-11 | th:objectでエンティティバインド | E-01 (8行目) | ○ |
| C-12 | remote検証: configId送信（自己除外） | E-01 (58-61行目) | ○ |
| C-13 | remote検証エラーメッセージ | E-01 (68-70行目) | ○ |
| C-14 | submitHandler定義 | E-01 (76-80行目) | ○ |
| C-15 | UPDATE文: WHERE config_id | E-04 (92-104行目) | ○ |
| C-16 | updateBy設定: getLoginName() | E-02 (119行目) | ○ |
| C-17 | update_time: sysdate() | E-04 (101行目) | ○ |
| C-18 | 旧キーと新キー比較処理 | E-05 (115-118行目) | ○ |
| C-19 | 旧キー異なる場合キャッシュ削除 | E-05 (117行目) | ○ |
| C-20 | 新キーキャッシュ登録 | E-05 (123行目) | ○ |
| C-21 | 重複チェック自己除外ロジック | E-05 (190-193行目) | ○ |
| C-22 | 機能No: 7（パラメータ設定） | E-06 (71行目) | ○ |
| C-23 | データ取得: selectConfigById | E-02 (102行目), E-05 (44-49行目) | ○ |
| C-24 | サーバーサイド重複チェック | E-02 (115-118行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面項目と更新カラムの対応は確実
- 0: 低リスク - 重複チェックの自己除外は実装確認済み
- 1: 中リスク - configKey変更時の影響範囲は別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 既存データが正しく初期表示されるか確認
- [ ] configKey変更時の重複チェックが動作するか確認
- [ ] 自分自身のconfigKeyは重複とみなされないか確認
- [ ] 更新後に一覧画面が正しく更新されるか確認
- [ ] configKey変更後、古いキャッシュが削除されるか確認
