---
generated_at: 2026-01-08 12:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-通知公告管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. **フルスクリーンモーダル**：addFull/editFullの動作確認
  2. **notice_contentのCAST**：BLOB型データの変換確認
  3. **タイトルリンク**：詳細画面への遷移確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/notice/notice.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysNoticeMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/notice | E-02 (36-41行目) | ○ |
| C-02 | 一覧API: POST /system/notice/list | E-02 (46-54行目) | ○ |
| C-03 | 削除API: POST /system/notice/remove | E-02 (114-124行目) | ○ |
| C-04 | 詳細表示: GET /system/notice/view/{noticeId} | E-02 (103-108行目) | ○ |
| C-05 | 権限制御: system:notice:add | E-01 (35行目), E-02 (59行目) | ○ |
| C-06 | 権限制御: system:notice:edit | E-01 (38行目), E-02 (82行目) | ○ |
| C-07 | 権限制御: system:notice:remove | E-01 (41行目), E-02 (118行目) | ○ |
| C-08 | 検索条件: noticeTitle（部分一致） | E-01 (14行目), E-04 (33-35行目) | ○ |
| C-09 | 検索条件: createBy（部分一致） | E-01 (17行目), E-04 (39-41行目) | ○ |
| C-10 | 検索条件: noticeType | E-01 (19-23行目), E-04 (36-38行目) | ○ |
| C-11 | 一覧カラム: noticeId | E-01 (70-73行目) | ○ |
| C-12 | 一覧カラム: noticeTitle（リンク） | E-01 (74-80行目) | ○ |
| C-13 | 一覧カラム: noticeType（辞書変換） | E-01 (81-88行目) | ○ |
| C-14 | 一覧カラム: status（辞書変換） | E-01 (89-96行目) | ○ |
| C-15 | 一覧カラム: createBy | E-01 (97-100行目) | ○ |
| C-16 | 一覧カラム: createTime（ソート可） | E-01 (101-105行目) | ○ |
| C-17 | addFull使用（フルスクリーン） | E-01 (35行目) | ○ |
| C-18 | editFull使用（フルスクリーン） | E-01 (38行目, 111行目) | ○ |
| C-19 | viewUrl設定 | E-01 (62行目) | ○ |
| C-20 | 対象テーブル: sys_notice | E-04 (22行目) | ○ |
| C-21 | notice_content CAST変換 | E-04 (21行目) | ○ |
| C-22 | 機能No: 6（通知公告） | E-06 (72行目) | ○ |
| C-23 | @Xss注釈（タイトル） | E-03 (49行目) | ○ |
| C-24 | deleteNoticeByIds実装 | E-05 (77-81行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URLマッピング、カラム定義は確実に検証済み
- 0: 低リスク - 権限制御の記述は複数ソースで確認
- 0: 低リスク - フルスクリーンモーダル使用は実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 画面表示URLが正しくアクセス可能か確認
- [ ] 権限のないユーザーでボタン非表示を確認
- [ ] 公告標題クリックで詳細画面に遷移するか確認
- [ ] 新増ボタンでフルスクリーンモーダルが開くか確認
- [ ] 削除実行時の確認ダイアログを確認
