---
generated_at: 2026-01-08 12:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-通知公告新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **Summernote画像アップロード**：コールバック処理の動作確認
  2. **XSSバリデーション**：スクリプト文字入力のブロック確認
  3. **HTML内容保存**：notice_contentの正常保存確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/notice/add.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysNoticeMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/notice/add | E-02 (59-63行目) | ○ |
| C-02 | 登録API: POST /system/notice/add | E-02 (69-77行目), E-01 (93行目) | ○ |
| C-03 | 画像アップロードAPI: POST /common/upload | E-01 (66行目) | ○ |
| C-04 | 権限制御: system:notice:add | E-02 (59,69行目) | ○ |
| C-05 | 入力項目: noticeTitle（必須、50文字） | E-01 (11-14行目), E-03 (50-51行目) | ○ |
| C-06 | 入力項目: noticeType（select） | E-01 (16-22行目) | ○ |
| C-07 | 入力項目: noticeContent（hidden+editor） | E-01 (25-28行目) | ○ |
| C-08 | 入力項目: status（radio、デフォルト0） | E-01 (31-38行目) | ○ |
| C-09 | Summernote CSS読み込み | E-01 (5行目) | ○ |
| C-10 | Summernote JS読み込み | E-01 (43行目) | ○ |
| C-11 | Summernote初期化（height:192） | E-01 (49行目) | ○ |
| C-12 | onImageUploadコールバック | E-01 (53-56行目) | ○ |
| C-13 | sendFile関数定義 | E-01 (61-83行目) | ○ |
| C-14 | 画像アップロード成功時エディタ挿入 | E-01 (74行目) | ○ |
| C-15 | 画像アップロード失敗時警告 | E-01 (80行目) | ○ |
| C-16 | submitHandler: summernote('code')取得 | E-01 (91行目) | ○ |
| C-17 | hiddenフィールド設定 | E-01 (92行目) | ○ |
| C-18 | INSERT文定義 | E-04 (45-63行目) | ○ |
| C-19 | createBy設定: getLoginName() | E-02 (75行目) | ○ |
| C-20 | create_time: sysdate() | E-04 (61行目) | ○ |
| C-21 | @Xss注釈（タイトル） | E-03 (49行目) | ○ |
| C-22 | 機能No: 6（通知公告） | E-06 (73行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入力項目定義は確実に検証済み
- 0: 低リスク - Summernote設定は実装確認済み
- 0: 低リスク - 画像アップロード処理は実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 公告標題の必須チェックが動作するか確認
- [ ] Summernoteエディタで書式設定が可能か確認
- [ ] 画像アップロードが正常に動作するか確認
- [ ] 登録後に一覧画面が正しく更新されるか確認
- [ ] XSS文字（<script>等）を含むタイトルがブロックされるか確認
