---
generated_at: 2026-01-08 12:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-通知公告編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. **既存内容のエディタ設定**：summernote('code', content)の動作確認
  2. **notice_content null許容**：UPDATE文のnullチェック確認
  3. **楽観的ロック**：同時更新時の挙動確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/notice/edit.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysNoticeMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/notice/edit/{noticeId} | E-02 (82-88行目) | ○ |
| C-02 | 更新API: POST /system/notice/edit | E-02 (93-101行目), E-01 (98行目) | ○ |
| C-03 | 権限制御: system:notice:edit | E-02 (82,93行目) | ○ |
| C-04 | 入力項目: noticeId（hidden） | E-01 (10行目) | ○ |
| C-05 | 入力項目: noticeTitle（既存値表示） | E-01 (12-15行目) | ○ |
| C-06 | 入力項目: noticeType（既存値選択） | E-01 (17-23行目) | ○ |
| C-07 | 入力項目: noticeContent（hidden、既存値） | E-01 (28行目) | ○ |
| C-08 | 入力項目: status（既存値選択） | E-01 (33-39行目) | ○ |
| C-09 | th:objectでエンティティバインド | E-01 (9行目) | ○ |
| C-10 | Summernote初期化 | E-01 (49-60行目) | ○ |
| C-11 | 既存内容取得（#noticeContent.val()） | E-01 (61行目) | ○ |
| C-12 | エディタへの内容設定 | E-01 (62行目) | ○ |
| C-13 | onImageUploadコールバック | E-01 (55-58行目) | ○ |
| C-14 | sendFile関数定義 | E-01 (66-88行目) | ○ |
| C-15 | submitHandler: summernote('code')取得 | E-01 (96行目) | ○ |
| C-16 | hiddenフィールド設定 | E-01 (97行目) | ○ |
| C-17 | UPDATE文: WHERE notice_id | E-04 (65-76行目) | ○ |
| C-18 | notice_content null許容 | E-04 (70行目) | ○ |
| C-19 | updateBy設定: getLoginName() | E-02 (99行目) | ○ |
| C-20 | update_time: sysdate() | E-04 (73行目) | ○ |
| C-21 | 機能No: 6（通知公告） | E-06 (74行目) | ○ |
| C-22 | データ取得: selectNoticeById | E-02 (86行目), E-05 (29-33行目) | ○ |
| C-23 | SELECT文定義 | E-04 (25-28行目) | ○ |
| C-24 | updateNotice実装 | E-05 (64-68行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面項目と更新カラムの対応は確実
- 0: 低リスク - Summernoteの既存内容設定は実装確認済み
- 1: 中リスク - 同時更新時の楽観的ロック機能なし

## 6) レビュアーチェックリスト（最小）
- [ ] 既存データが正しく初期表示されるか確認
- [ ] Summernoteエディタに既存の公告内容が表示されるか確認
- [ ] 画像追加後の更新が正常に動作するか確認
- [ ] 更新後に一覧画面が正しく更新されるか確認
- [ ] 内容を空にして更新した場合の動作を確認
