---
generated_at: 2026-01-08 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-システム首頁（トップナビ型）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/index-topnav.html` - トップナビ型テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` - インデックスコントローラー
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Cookie nav-style=topnavでトップナビ型選択 | E-02 (79-84行目 cookie nav-style) | ○ |
| C-02 | テンプレート名はindex-topnav | E-02 (85行目 return "index-topnav") | ○ |
| C-03 | 第1階層メニューがトップナビに水平表示 | E-01 (226-235行目 navbar-toolbar) | ○ |
| C-04 | サブメニューはtab-contentで管理 | E-01 (33行目 tab-content, 50行目 tab-pane) | ○ |
| C-05 | 左側メニュー切替は /system/menuStyle/default | E-02 (126-130行目 menuStyle), E-01 (373行目) | ○ |
| C-06 | 切替時に確認ダイアログ表示 | E-01 (372行目 $.modal.confirm) | ○ |
| C-07 | タブバーが存在 | E-01 (288-301行目 page-tabs menuTabs) | ○ |
| C-08 | iframeコンテンツ領域が存在 | E-01 (305-308行目 iframe RuoYi_iframe) | ○ |
| C-09 | resize-tabs.jsを読み込み | E-01 (328行目 resize-tabs.js) | ○ |
| C-10 | ユーザードロップダウンメニューが存在 | E-01 (256-284行目 dropdown-menu) | ○ |
| C-11 | 「左側菜单」切替オプション | E-01 (274-276行目 toggleMenu) | ○ |
| C-12 | 「統計報表」固定タブが存在 | E-01 (237-241行目 tab_index) | ○ |
| C-13 | 「実例演示」固定タブが存在（設定依存） | E-01 (243-247行目 tab_demo demoEnabled) | ○ |
| C-14 | 機能No.19「ログイン」がAPI連携 | E-03 (9行目) | ○ |
| C-15 | メインカテゴリは「メイン」 | E-04 (6行目) | ○ |
| C-16 | テンプレートファイルパスはindex-topnav.html | E-04 (6行目) | ○ |
| C-17 | 画面遷移：トップナビ型→メインコンテンツ | E-05 (53行目 IndexTopNav --> Main) | ○ |
| C-18 | applyPath関数でタブ・メニュー同期 | E-01 (380-393行目 applyPath) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] トップナビゲーションのレスポンシブ動作確認
- [ ] resize-tabs.jsによるタブ幅調整動作確認
- [ ] 左側メニュー型との切り替え動作確認
