---
generated_at: 2026-01-08 12:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-通知公告表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **th:utextでのHTML表示**：XSS対策の確認
  2. **notice_contentのCAST変換**：BLOB型の正常表示確認
  3. **日付フォーマット**：表示形式の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/system/notice/view.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java`
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysNoticeMapper.xml`
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: GET /system/notice/view/{noticeId} | E-02 (103-112行目) | ○ |
| C-02 | 権限制御: system:notice:list | E-02 (106行目) | ○ |
| C-03 | 表示項目: noticeTitle（中央揃えh3） | E-01 (12行目) | ○ |
| C-04 | 表示項目: createBy | E-01 (15行目) | ○ |
| C-05 | 表示項目: createTime（日付フォーマット） | E-01 (14行目) | ○ |
| C-06 | 日付フォーマット: yyyy-MM-dd HH:mm:ss | E-01 (14行目) | ○ |
| C-07 | 表示項目: noticeContent（th:utext） | E-01 (20行目) | ○ |
| C-08 | th:utextでHTMLレンダリング | E-01 (20行目) | ○ |
| C-09 | メールボックス風レイアウト | E-01 (10-21行目) | ○ |
| C-10 | main-contentクラス使用 | E-01 (7行目) | ○ |
| C-11 | SELECT文: CAST(notice_content as char) | E-04 (21行目) | ○ |
| C-12 | selectNoticeById定義 | E-04 (25-28行目) | ○ |
| C-13 | 機能No: 6（通知公告） | E-06 (75行目) | ○ |
| C-14 | データ取得: selectNoticeById | E-02 (110行目), E-05 (29-33行目) | ○ |
| C-15 | include footer | E-01 (25行目) | ○ |
| C-16 | include header | E-01 (4行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URLマッピングは確実に検証済み
- 0: 低リスク - 表示項目の配置は確実に検証済み
- 1: 中リスク - th:utextでのHTML表示はXSS脆弱性に注意（ただし管理者作成コンテンツのため低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] 画面表示URLが正しくアクセス可能か確認
- [ ] 公告標題が中央揃えで表示されるか確認
- [ ] 発件人と発送時間が正しく表示されるか確認
- [ ] Summernoteで作成した書式が正しく表示されるか確認
- [ ] 埋め込み画像が正しく表示されるか確認
