---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：51-オンラインユーザー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Redisキャッシュとの連携詳細**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/monitor/online/online.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserOnline.java`
- E-04: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserOnlineService.java`
- E-05: `ruoyi-system/src/main/resources/mapper/system/SysUserOnlineMapper.xml`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/monitor/onlineである | E-02 (43-47行目) | ○ |
| C-02 | 一覧取得はPOST /monitor/online/listである | E-02 (49-57行目) | ○ |
| C-03 | 強制ログアウトはPOST /monitor/online/batchForceLogoutである | E-02 (59-87行目) | ○ |
| C-04 | 検索条件にipaddr（登録地址）がある | E-01 (14行目), E-05 (43-45行目) | ○ |
| C-05 | 検索条件にloginName（登録名称）がある | E-01 (17行目), E-05 (46-48行目) | ○ |
| C-06 | 表示項目にsessionId（会話編号）がある | E-01 (64-68行目), E-03 (19行目) | ○ |
| C-07 | 表示項目にloginName（登録名称）がある | E-01 (70-73行目), E-03 (25行目) | ○ |
| C-08 | 表示項目にdeptName（部門名称）がある | E-01 (75-77行目), E-03 (22行目) | ○ |
| C-09 | 表示項目にipaddr（主机）がある | E-01 (79-81行目), E-03 (28行目) | ○ |
| C-10 | 表示項目にloginLocation（登録地点）がある | E-01 (83-85行目), E-03 (31行目) | ○ |
| C-11 | 表示項目にbrowser（ブラウザ）がある | E-01 (87-89行目), E-03 (34行目) | ○ |
| C-12 | 表示項目にos（操作系統）がある | E-01 (91-93行目), E-03 (37行目) | ○ |
| C-13 | 表示項目にstatus（会話状態）がある | E-01 (95-105行目), E-03 (49行目) | ○ |
| C-14 | 表示項目にstartTimestamp（登録時間）がある | E-01 (107-110行目), E-03 (40行目) | ○ |
| C-15 | 表示項目にlastAccessTime（最後アクセス時間）がある | E-01 (112-115行目), E-03 (43行目) | ○ |
| C-16 | 強退機能に権限チェックがある（monitor:online:forceLogout） | E-01 (42行目), E-02 (59行目) | ○ |
| C-17 | 一括強退機能に権限チェックがある（monitor:online:batchForceLogout） | E-01 (29行目), E-02 (59行目) | ○ |
| C-18 | 自分自身は強退できない | E-02 (77-79行目) | ○ |
| C-19 | エラーメッセージ「用戸已下線」が存在する | E-02 (70-71行目, 74-75行目) | ○ |
| C-20 | エラーメッセージ「当前登録用戸無法強退」が存在する | E-02 (79行目) | ○ |
| C-21 | sys_user_onlineテーブルが使用される | E-05 (23行目) | ○ |
| C-22 | ステータスはon_line/off_lineの列挙型である | E-03 (49行目) | ○ |
| C-23 | 画面カテゴリは「システム監視」である | E-06 (52行目) | ○ |
| C-24 | 関連機能は「オンラインユーザー」（機能No.12）である | E-07 (76行目) | ○ |
| C-25 | Redisキャッシュからセッション情報を削除する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: Redisキャッシュとの連携について、OnlineSessionDAOの実装を確認する必要がある
  - 候補：OnlineSessionDAO.java / ShiroConfig.java / application.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコードと整合している
- 1: 中リスク - キャッシュ連携の実装詳細について追加確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目が実際の画面と一致しているか確認
- [ ] 権限設定が要件と一致しているか確認
- [ ] エラーメッセージの日本語訳が適切か確認
- [ ] キャッシュ削除処理の実装を確認（OnlineSessionDAO）
