---
generated_at: 2026-01-08 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：52-定時任務管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-quartz/src/main/resources/templates/monitor/job/job.html`
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java`
- E-04: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobService.java`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/monitor/jobである | E-02 (36行目, 44-49行目) | ○ |
| C-02 | 一覧取得はPOST /monitor/job/listである | E-02 (51-59行目) | ○ |
| C-03 | 削除はPOST /monitor/job/removeである | E-02 (72-80行目) | ○ |
| C-04 | ステータス変更はPOST /monitor/job/changeStatusである | E-02 (94-103行目) | ○ |
| C-05 | 即時実行はPOST /monitor/job/runである | E-02 (108-116行目) | ○ |
| C-06 | Cron式生成器はGET /monitor/job/cronである | E-02 (225-229行目) | ○ |
| C-07 | 検索条件にjobName（任務名称）がある | E-01 (14行目) | ○ |
| C-08 | 検索条件にjobGroup（任務分組）がある | E-01 (16-20行目) | ○ |
| C-09 | 検索条件にstatus（任務状態）がある | E-01 (22-26行目) | ○ |
| C-10 | 表示項目にjobId（任務編号）がある | E-01 (86-88行目), E-03 (26行目) | ○ |
| C-11 | 表示項目にjobName（任務名称）がある | E-01 (90-92行目), E-03 (30行目) | ○ |
| C-12 | 表示項目にjobGroup（任務分組）がある | E-01 (94-99行目), E-03 (34行目) | ○ |
| C-13 | 表示項目にinvokeTarget（調用目標字符串）がある | E-01 (101-106行目), E-03 (38行目) | ○ |
| C-14 | 表示項目にcronExpression（執行表達式）がある | E-01 (108-110行目), E-03 (42行目) | ○ |
| C-15 | 表示項目にstatus（任務状態）がある | E-01 (112-118行目), E-03 (54行目) | ○ |
| C-16 | 表示項目にcreateTime（創建時間）がある | E-01 (120-123行目) | ○ |
| C-17 | 新増機能に権限チェックがある（monitor:job:add） | E-01 (38行目), E-02 (121行目) | ○ |
| C-18 | 編集機能に権限チェックがある（monitor:job:edit） | E-01 (41行目), E-02 (168行目) | ○ |
| C-19 | 削除機能に権限チェックがある（monitor:job:remove） | E-01 (44行目), E-02 (73行目) | ○ |
| C-20 | ステータス変更機能に権限チェックがある（monitor:job:changeStatus） | E-02 (95行目) | ○ |
| C-21 | Excelエクスポート機能がある | E-01 (47-48行目), E-02 (61-70行目) | ○ |
| C-22 | 詳細表示機能がある | E-01 (134行目), E-02 (82-89行目) | ○ |
| C-23 | 日志画面への遷移機能がある | E-01 (53-54行目, 135行目, 175-181行目) | ○ |
| C-24 | Cron式生成器の呼び出し機能がある | E-01 (50-51行目, 184-195行目), E-02 (225-229行目) | ○ |
| C-25 | 即時実行の確認メッセージがある | E-01 (155行目) | ○ |
| C-26 | 停止の確認メッセージがある | E-01 (162行目) | ○ |
| C-27 | 有効化の確認メッセージがある | E-01 (169行目) | ○ |
| C-28 | 画面カテゴリは「システム監視」である | E-05 (53行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコードと整合している

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目が実際の画面と一致しているか確認
- [ ] 権限設定が要件と一致しているか確認
- [ ] Quartzスケジューラとの連携が正しく動作するか確認
- [ ] Cron式のバリデーションが適切か確認
