---
generated_at: 2026-01-08 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-定時任務新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-quartz/src/main/resources/templates/monitor/job/add.html`
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLはGET /monitor/job/addである | E-02 (121-126行目) | ○ |
| C-02 | 保存URLはPOST /monitor/job/addである | E-02 (131-163行目) | ○ |
| C-03 | Cron式検証URLはPOST /monitor/job/checkCronExpressionIsValidである | E-02 (215-220行目) | ○ |
| C-04 | 入力項目にcreateByがある（hidden） | E-01 (9行目) | ○ |
| C-05 | 入力項目にjobName（任務名称）がある（必須） | E-01 (11-14行目), E-03 (66-68行目) | ○ |
| C-06 | 入力項目にjobGroup（任務分組）がある | E-01 (16-22行目) | ○ |
| C-07 | 入力項目にinvokeTarget（調用目標字符串）がある（必須） | E-01 (24-31行目), E-03 (88-90行目) | ○ |
| C-08 | 入力項目にcronExpression（cron表達式）がある（必須） | E-01 (33-37行目), E-03 (100-102行目) | ○ |
| C-09 | 入力項目にmisfirePolicy（執行策略）がある | E-01 (39-45行目) | ○ |
| C-10 | 入力項目にconcurrent（並発執行）がある | E-01 (47-52行目) | ○ |
| C-11 | 入力項目にremark（備注）がある | E-01 (54-58行目) | ○ |
| C-12 | Cron式のバリデーションがある | E-01 (68-91行目) | ○ |
| C-13 | RMI呼び出しは禁止される | E-02 (141-144行目) | ○ |
| C-14 | LDAP呼び出しは禁止される | E-02 (145-148行目) | ○ |
| C-15 | HTTP呼び出しは禁止される | E-02 (149-152行目) | ○ |
| C-16 | ホワイトリストチェックがある | E-02 (157-160行目) | ○ |
| C-17 | エラーメッセージ「表達式不正確」がある | E-01 (87行目) | ○ |
| C-18 | jobNameの最大長は64文字である | E-03 (67行目) | ○ |
| C-19 | invokeTargetの最大長は1000文字である | E-03 (89行目) | ○ |
| C-20 | cronExpressionの最大長は255文字である | E-03 (101行目) | ○ |
| C-21 | 画面カテゴリは「システム監視」である | E-04 (54行目) | ○ |
| C-22 | 関連機能は「定期タスク管理」（機能No.16）である | E-05 (79行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコードと整合している

## 6) レビュアーチェックリスト（最小）
- [ ] 入力項目の必須/任意設定が要件と一致しているか確認
- [ ] セキュリティチェックが十分か確認
- [ ] ホワイトリストの設定が適切か確認
