---
generated_at: 2026-01-08 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-定時任務編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-quartz/src/main/resources/templates/monitor/job/edit.html`
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLはGET /monitor/job/edit/{jobId}である | E-02 (168-174行目) | ○ |
| C-02 | 保存URLはPOST /monitor/job/editである | E-02 (179-210行目) | ○ |
| C-03 | 入力項目にjobId（hidden）がある | E-01 (9行目) | ○ |
| C-04 | 入力項目にupdateBy（hidden）がある | E-01 (10行目) | ○ |
| C-05 | 入力項目にjobName（任務名称）がある | E-01 (12-15行目) | ○ |
| C-06 | 入力項目にjobGroup（任務分組）がある | E-01 (17-23行目) | ○ |
| C-07 | 入力項目にinvokeTarget（調用目標字符串）がある | E-01 (25-32行目) | ○ |
| C-08 | 入力項目にcronExpression（cron表達式）がある | E-01 (34-38行目) | ○ |
| C-09 | 入力項目にmisfirePolicy（執行策略）がある | E-01 (40-46行目) | ○ |
| C-10 | 入力項目にconcurrent（並発執行）がある | E-01 (48-53行目) | ○ |
| C-11 | 入力項目にstatus（状態）がある | E-01 (55-62行目) | ○ |
| C-12 | 入力項目にremark（備注）がある | E-01 (64-68行目) | ○ |
| C-13 | Cron式のバリデーションがある | E-01 (76-102行目) | ○ |
| C-14 | セキュリティチェックがある | E-02 (185-207行目) | ○ |
| C-15 | th:objectでjobをバインドしている | E-01 (8行目) | ○ |
| C-16 | th:fieldでデータバインディングしている | E-01 (9行目, 14行目等) | ○ |
| C-17 | エラーメッセージ「表達式不正確」がある | E-01 (98行目) | ○ |
| C-18 | 画面カテゴリは「システム監視」である | E-04 (55行目) | ○ |
| C-19 | 関連機能は「定期タスク管理」（機能No.16）である | E-05 (80行目) | ○ |
| C-20 | 状態は辞書sys_job_statusから取得している | E-01 (58行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコードと整合している

## 6) レビュアーチェックリスト（最小）
- [ ] 新規登録画面との差分（status項目）が正しいか確認
- [ ] セキュリティチェックが適切か確認
- [ ] Thymeleafのデータバインディングが正しく動作するか確認
