---
generated_at: 2026-01-08 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-定時任務詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-quartz/src/main/resources/templates/monitor/job/detail.html`
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLはGET /monitor/job/detail/{jobId}である | E-02 (82-89行目) | ○ |
| C-02 | ModelMapにname="job"を設定する | E-02 (86行目) | ○ |
| C-03 | 表示項目にjobId（任務序号）がある | E-01 (49-51行目) | ○ |
| C-04 | 表示項目にjobName（任務名称）がある | E-01 (53-56行目) | ○ |
| C-05 | 表示項目にjobGroup（任務分組）がある | E-01 (58-61行目) | ○ |
| C-06 | 表示項目にinvokeTarget（調用目標字符串）がある | E-01 (63-66行目) | ○ |
| C-07 | 表示項目にcronExpression（執行表達式）がある | E-01 (68-71行目) | ○ |
| C-08 | 表示項目にnextValidTime（下次執行時間）がある | E-01 (73-76行目) | ○ |
| C-09 | 表示項目にmisfirePolicy（執行策略）がある | E-01 (78-84行目) | ○ |
| C-10 | 表示項目にconcurrent（並発執行）がある | E-01 (85-88行目) | ○ |
| C-11 | 表示項目にstatus（執行状態）がある | E-01 (89-92行目) | ○ |
| C-12 | nextValidTimeはgetNextValidTime()で計算される | E-03 (112-119行目) | ○ |
| C-13 | th:if="${name == 'job'}"で条件分岐している | E-01 (47行目) | ○ |
| C-14 | 画面カテゴリは「システム監視」である | E-04 (56行目) | ○ |
| C-15 | 関連機能は「定期タスク管理」（機能No.16）である | E-05 (81行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコードと整合している

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目が実際の画面と一致しているか確認
- [ ] 次回実行時刻の計算が正しいか確認
- [ ] 執行策略、並発執行、執行状態のラベル表示が正しいか確認
