---
generated_at: 2026-01-08 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-定時任務ログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-quartz/src/main/resources/templates/monitor/job/jobLog.html`
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java`
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java`
- E-04: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobLogService.java`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLはGET /monitor/jobLogである | E-02 (43-53行目) | ○ |
| C-02 | 一覧取得はPOST /monitor/jobLog/listである | E-02 (55-63行目) | ○ |
| C-03 | 削除はPOST /monitor/jobLog/removeである | E-02 (76-83行目) | ○ |
| C-04 | 清空はPOST /monitor/jobLog/cleanである | E-02 (94-102行目) | ○ |
| C-05 | 詳細はGET /monitor/jobLog/detail/{jobLogId}である | E-02 (85-92行目) | ○ |
| C-06 | 検索条件にjobName（任務名称）がある | E-01 (14行目) | ○ |
| C-07 | 検索条件にjobGroup（任務分組）がある | E-01 (17-21行目) | ○ |
| C-08 | 検索条件にstatus（執行状態）がある | E-01 (23-28行目) | ○ |
| C-09 | 検索条件に時間範囲がある | E-01 (30-35行目) | ○ |
| C-10 | 表示項目にjobLogId（日志編号）がある | E-01 (70-73行目), E-03 (20行目) | ○ |
| C-11 | 表示項目にjobName（任務名称）がある | E-01 (75-77行目), E-03 (24行目) | ○ |
| C-12 | 表示項目にjobGroup（任務分組）がある | E-01 (79-84行目), E-03 (28行目) | ○ |
| C-13 | 表示項目にinvokeTarget（調用目標字符串）がある | E-01 (86-91行目), E-03 (32行目) | ○ |
| C-14 | 表示項目にjobMessage（日志信息）がある | E-01 (93-95行目), E-03 (36行目) | ○ |
| C-15 | 表示項目にstatus（執行状態）がある | E-01 (97-106行目), E-03 (40行目) | ○ |
| C-16 | 表示項目にcreateTime（執行時間）がある | E-01 (108-111行目) | ○ |
| C-17 | 削除機能に権限チェックがある（monitor:job:remove） | E-01 (41行目), E-02 (77行目) | ○ |
| C-18 | 清空機能に権限チェックがある（monitor:job:remove） | E-01 (44行目), E-02 (95行目) | ○ |
| C-19 | cleanJobLogメソッドがある | E-04 (55行目) | ○ |
| C-20 | 確認メッセージ「是否確認清空所有調度日志数据項?」がある | E-01 (118行目) | ○ |
| C-21 | 画面カテゴリは「システム監視」である | E-05 (57行目) | ○ |
| C-22 | 関連機能は「定期タスク管理」（機能No.16）である | E-06 (82行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコードと整合している

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目が実際の画面と一致しているか確認
- [ ] 権限設定が要件と一致しているか確認
- [ ] 清空操作の確認ダイアログが適切か確認
