---
generated_at: 2026-01-08 11:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：57-Cron式生成器

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **反向解析機能の詳細**：JavaScript実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-quartz/src/main/resources/templates/monitor/job/cron.html`
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/CronUtils.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLはGET /monitor/job/cronである | E-02 (225-229行目) | ○ |
| C-02 | 次回実行時刻取得URLはGET /monitor/job/queryCronExpressionである | E-02 (234-247行目) | ○ |
| C-03 | 秒/分/時/日/月/週のタブ構成である | E-01 | ○ |
| C-04 | 次回10回の実行時刻を表示する | E-02 (240行目) | ○ |
| C-05 | CronUtils.getRecentTriggerTimeを使用する | E-02 (240行目) | ○ |
| C-06 | Cron式の検証機能がある | E-02 (238行目) | ○ |
| C-07 | 「表達式無效」エラーメッセージがある | E-02 (245行目) | ○ |
| C-08 | 6フィールド形式（秒 分 時 日 月 週）を使用 | E-01 | ○ |
| C-09 | 「?」は日と週の不指定を表す | E-01 | ○ |
| C-10 | 「L」は月末日を表す | E-01 | ○ |
| C-11 | 「#」は第N週の曜日を表す | E-01 | ○ |
| C-12 | 「/」は間隔を表す | E-01 | ○ |
| C-13 | 画面カテゴリは「システム監視」である | E-04 (58行目) | ○ |
| C-14 | 関連機能は「定期タスク管理」（機能No.16）である | E-05 (83行目) | ○ |
| C-15 | 反向解析機能がある | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: 反向解析機能のJavaScript実装詳細を確認する必要がある
  - 候補：cron.html内のJavaScript関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能は明確でコードと整合している
- 1: 中リスク - 反向解析機能のJS実装確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 各タブの入力項目が実際の画面と一致しているか確認
- [ ] Cron式の生成ロジックが正しいか確認
- [ ] 次回実行時刻の計算が正しいか確認
- [ ] 反向解析機能が正しく動作するか確認
