---
generated_at: 2026-01-08 11:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-操作ログ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/monitor/operlog/operlog.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java`
- E-04: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysOperLogService.java`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLはGET /monitor/operlogである | E-02 (36-41行目) | ○ |
| C-02 | 一覧取得はPOST /monitor/operlog/listである | E-02 (43-51行目) | ○ |
| C-03 | 削除はPOST /monitor/operlog/removeである | E-02 (64-71行目) | ○ |
| C-04 | 清空はPOST /monitor/operlog/cleanである | E-02 (81-89行目) | ○ |
| C-05 | 詳細はGET /monitor/operlog/detail/{operId}である | E-02 (73-78行目) | ○ |
| C-06 | 検索条件にoperIp（操作地址）がある | E-01 (15行目) | ○ |
| C-07 | 検索条件にtitle（系統模塊）がある | E-01 (18行目) | ○ |
| C-08 | 検索条件にoperName（操作人員）がある | E-01 (21行目) | ○ |
| C-09 | 検索条件にbusinessTypes（操作類型）がある（複数選択） | E-01 (23-26行目) | ○ |
| C-10 | 検索条件にstatus（操作状態）がある | E-01 (28-32行目) | ○ |
| C-11 | 検索条件に時間範囲がある | E-01 (34-39行目) | ○ |
| C-12 | 表示項目にoperId（日志編号）がある | E-01 (92-95行目), E-03 (21行目) | ○ |
| C-13 | 表示項目にtitle（系統模塊）がある | E-01 (97-102行目), E-03 (25行目) | ○ |
| C-14 | 表示項目にbusinessType（操作類型）がある | E-01 (104-110行目), E-03 (29行目) | ○ |
| C-15 | 表示項目にoperName（操作人員）がある | E-01 (112-115行目), E-03 (48行目) | ○ |
| C-16 | 表示項目にdeptName（部門名称）がある | E-01 (117-119行目), E-03 (51行目) | ○ |
| C-17 | 表示項目にoperIp（操作地址）がある | E-01 (121-123行目), E-03 (60行目) | ○ |
| C-18 | 表示項目にoperLocation（操作地点）がある | E-01 (125-127行目), E-03 (64行目) | ○ |
| C-19 | 表示項目にstatus（操作状態）がある | E-01 (129-138行目), E-03 (76行目) | ○ |
| C-20 | 表示項目にoperTime（操作時間）がある | E-01 (140-143行目), E-03 (84行目) | ○ |
| C-21 | 表示項目にcostTime（消耗時間）がある | E-01 (145-152行目), E-03 (88行目) | ○ |
| C-22 | 削除機能に権限チェックがある（monitor:operlog:remove） | E-01 (50行目), E-02 (65行目) | ○ |
| C-23 | 清空機能に権限チェックがある（monitor:operlog:remove） | E-01 (53行目), E-02 (82行目) | ○ |
| C-24 | 導出機能に権限チェックがある（monitor:operlog:export） | E-01 (56行目), E-02 (54行目) | ○ |
| C-25 | 詳細機能に権限チェックがある（monitor:operlog:detail） | E-01 (70行目), E-02 (73行目) | ○ |
| C-26 | cleanOperLogメソッドがある | E-04 (47行目) | ○ |
| C-27 | 画面カテゴリは「日志管理」である | E-05 (59行目) | ○ |
| C-28 | 関連機能は「操作ログ」（機能No.18）である | E-06 (84行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコードと整合している

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目が実際の画面と一致しているか確認
- [ ] 権限設定が要件と一致しているか確認
- [ ] 操作類型の辞書データが正しいか確認
- [ ] 清空操作の確認ダイアログが適切か確認
