---
generated_at: 2026-01-08 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-操作ログ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/monitor/operlog/detail.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLはGET /monitor/operlog/detail/{operId}である | E-02 (73-78行目) | ○ |
| C-02 | 表示項目に操作模塊（title + businessType）がある | E-01 (11-13行目) | ○ |
| C-03 | 表示項目に登録信息（operName + deptName + operIp + operLocation）がある | E-01 (15-18行目) | ○ |
| C-04 | 表示項目に請求地址（requestMethod + operUrl + costTime）がある | E-01 (20-22行目) | ○ |
| C-05 | 表示項目に操作方法（method）がある | E-01 (25-27行目) | ○ |
| C-06 | 表示項目に請求参数（operParam）がある | E-01 (30-32行目) | ○ |
| C-07 | 表示項目に返回参数（jsonResult）がある | E-01 (34-36行目) | ○ |
| C-08 | 表示項目に状態（status）がある | E-01 (38-41行目) | ○ |
| C-09 | 表示項目に異常信息（errorMsg）がある | E-01 (43-46行目) | ○ |
| C-10 | 操作類型は辞書（sys_oper_type）から取得する | E-01 (12行目) | ○ |
| C-11 | JSONViewライブラリを使用してJSON整形表示する | E-01 (5行目, 52-66行目) | ○ |
| C-12 | 2000文字以上はテキスト表示する | E-01 (55行目, 61行目) | ○ |
| C-13 | 異常信息はstatus=1の場合のみ表示する | E-01 (43行目) | ○ |
| C-14 | 状態0は正常ラベル、状態1は異常ラベルで表示する | E-01 (40行目) | ○ |
| C-15 | 権限チェックがある（monitor:operlog:detail） | E-02 (73行目) | ○ |
| C-16 | ModelMapにoperLogを設定する | E-02 (77行目) | ○ |
| C-17 | 画面カテゴリは「日志管理」である | E-04 (60行目) | ○ |
| C-18 | 関連機能は「操作ログ」（機能No.18）である | E-05 (85行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコードと整合している

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目が実際の画面と一致しているか確認
- [ ] JSONViewの表示が正しく動作するか確認
- [ ] 2000文字制限の動作を確認
- [ ] 異常信息の条件付き表示が正しく動作するか確認
