---
generated_at: 2026-01-08 10:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-メインコンテンツ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/main.html` - メインコンテンツテンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` - インデックスコントローラー
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メインコンテンツのURLは `/system/main` | E-02 (133行目 @GetMapping("/system/main")) | ○ |
| C-02 | バージョン情報を表示 | E-01 (28行目 version), E-02 (136行目 RuoYiConfig.getVersion()) | ○ |
| C-03 | 「Hello,Guest」挨拶を表示 | E-01 (17行目 Hello,Guest) | ○ |
| C-04 | QRコード画像を表示 | E-01 (21行目 qr_code.png) | ○ |
| C-05 | 技術スタック一覧を表示 | E-01 (45-53行目 ol li) | ○ |
| C-06 | Giteeリンクが存在 | E-01 (35-37行目 gitee.com) | ○ |
| C-07 | 公式サイトリンクが存在 | E-01 (38-40行目 ruoyi.vip) | ○ |
| C-08 | 連絡先情報を表示 | E-01 (67-76行目 联系信息) | ○ |
| C-09 | 更新日志をアコーディオン形式で表示 | E-01 (86-200行目 panel-group collapse) | ○ |
| C-10 | 「¥免費開源」ラベル表示 | E-01 (30-32行目 label label-warning) | ○ |
| C-11 | QQ群一覧表示（満員は取り消し線） | E-01 (70行目 s tag) | ○ |
| C-12 | 機能No.19「ログイン」が補助機能 | E-03 (10行目) | ○ |
| C-13 | メインカテゴリは「メイン」 | E-04 (7行目) | ○ |
| C-14 | テンプレートファイルパスはmain.html | E-04 (7行目) | ○ |
| C-15 | iboxコンポーネント使用 | E-01 (62行目, 79行目 ibox float-e-margins) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] バージョン情報が正しく表示されることを確認
- [ ] 更新履歴アコーディオンの動作確認
