---
generated_at: 2026-01-08 11:15:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-ログインログ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/monitor/logininfor/logininfor.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java`
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java`
- E-04: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysLogininforService.java`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示URLはGET /monitor/logininforである | E-02 (38-43行目) | ○ |
| C-02 | 一覧取得はPOST /monitor/logininfor/listである | E-02 (45-53行目) | ○ |
| C-03 | 削除はPOST /monitor/logininfor/removeである | E-02 (66-73行目) | ○ |
| C-04 | 清空はPOST /monitor/logininfor/cleanである | E-02 (75-82行目) | ○ |
| C-05 | 解鎖はPOST /monitor/logininfor/unlockである | E-02 (85-93行目) | ○ |
| C-06 | 検索条件にipaddr（登録地址）がある | E-01 (14行目) | ○ |
| C-07 | 検索条件にloginName（登録名称）がある | E-01 (17行目) | ○ |
| C-08 | 検索条件にstatus（登録状態）がある | E-01 (20-24行目) | ○ |
| C-09 | 検索条件に時間範囲がある | E-01 (25-30行目) | ○ |
| C-10 | 表示項目にinfoId（訪問編号）がある | E-01 (83-85行目), E-03 (21行目) | ○ |
| C-11 | 表示項目にloginName（登録名称）がある | E-01 (87-90行目), E-03 (25行目) | ○ |
| C-12 | 表示項目にipaddr（登録地址）がある | E-01 (92-97行目), E-03 (33行目) | ○ |
| C-13 | 表示項目にloginLocation（登録地点）がある | E-01 (99-101行目), E-03 (37行目) | ○ |
| C-14 | 表示項目にbrowser（ブラウザ）がある | E-01 (103-105行目), E-03 (41行目) | ○ |
| C-15 | 表示項目にos（操作系統）がある | E-01 (107-109行目), E-03 (45行目) | ○ |
| C-16 | 表示項目にstatus（登録状態）がある | E-01 (111-117行目), E-03 (29行目) | ○ |
| C-17 | 表示項目にmsg（操作信息）がある | E-01 (119-121行目), E-03 (49行目) | ○ |
| C-18 | 表示項目にloginTime（登録時間）がある | E-01 (123-126行目), E-03 (53行目) | ○ |
| C-19 | 削除機能に権限チェックがある（monitor:logininfor:remove） | E-01 (41行目), E-02 (66行目) | ○ |
| C-20 | 清空機能に権限チェックがある（monitor:logininfor:remove） | E-01 (44行目), E-02 (75行目) | ○ |
| C-21 | 解鎖機能に権限チェックがある（monitor:logininfor:unlock） | E-01 (47行目), E-02 (85行目) | ○ |
| C-22 | 導出機能に権限チェックがある（monitor:logininfor:export） | E-01 (50行目), E-02 (55行目) | ○ |
| C-23 | cleanLogininforメソッドがある | E-04 (39行目) | ○ |
| C-24 | unlock関数がある | E-01 (141-143行目), E-02 (85-93行目) | ○ |
| C-25 | 画面カテゴリは「日志管理」である | E-05 (61行目) | ○ |
| C-26 | 関連機能は「ログインログ」（機能No.19）である | E-06 (86行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は明確でコードと整合している

## 6) レビュアーチェックリスト（最小）
- [ ] 表示項目が実際の画面と一致しているか確認
- [ ] 権限設定が要件と一致しているか確認
- [ ] 解鎖機能がキャッシュを正しくクリアするか確認
- [ ] 清空操作の確認ダイアログが適切か確認
