---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：61-サーバー監視

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **権限エラー時のリダイレクト先**：403エラー画面の具体的なパスは未確認
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/ServerController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/Server.java`
- E-03: `ruoyi-admin/src/main/resources/templates/monitor/server/server.html`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/monitor/serverである | E-01 L17 `@RequestMapping("/monitor/server")` | ○ |
| C-02 | monitor:server:view権限が必要 | E-01 L22 `@RequiresPermissions("monitor:server:view")` | ○ |
| C-03 | Serverクラスで情報収集する | E-01 L26-27, E-02 | ○ |
| C-04 | CPUコア数を表示する | E-03 L31 `${server.cpu.cpuNum}` | ○ |
| C-05 | CPU使用率を表示する | E-03 L35 `${server.cpu.used}` | ○ |
| C-06 | メモリ総量をGB単位で表示 | E-03 L72 `${server.mem.total + 'G'}` | ○ |
| C-07 | JVMメモリをMB単位で表示 | E-03 L73 `${server.jvm.total + 'M'}` | ○ |
| C-08 | 80%超で赤字警告表示 | E-03 L87-88 `th:class="${server.mem.usage gt 80} ? 'text-danger'"` | ○ |
| C-09 | サーバー名を表示 | E-03 L118 `${server.sys.computerName}` | ○ |
| C-10 | OS名を表示 | E-03 L120 `${server.sys.osName}` | ○ |
| C-11 | サーバーIPを表示 | E-03 L124 `${server.sys.computerIp}` | ○ |
| C-12 | Java名称を表示 | E-03 L159 `${server.jvm.name}` | ○ |
| C-13 | Javaバージョンを表示 | E-03 L161 `${server.jvm.version}` | ○ |
| C-14 | 起動時間を表示 | E-03 L165 `${server.jvm.startTime}` | ○ |
| C-15 | 運行時間を表示 | E-03 L167 `${server.jvm.runTime}` | ○ |
| C-16 | ディスク情報をループ表示 | E-03 L221 `th:each="sysFile : ${server.sysFiles}"` | ○ |
| C-17 | ディスク使用率80%超で赤字 | E-03 L228 `th:class="${sysFile.usage gt 80} ? 'text-danger'"` | ○ |
| C-18 | OSHIライブラリを使用 | E-02 L14-22 `import oshi.*` | ○ |
| C-19 | CPU取得時に1秒ウェイト | E-02 L32, L132 `OSHI_WAIT_SECOND = 1000`, `Util.sleep(OSHI_WAIT_SECOND)` | ○ |
| C-20 | パネル折りたたみ機能あり | E-03 L243-252 `.collapse-link`クリックハンドラ | ○ |
| C-21 | パネル閉じる機能あり | E-03 L253-256 `.close-link`クリックでremove() | ○ |
| C-22 | 関連機能はサーバー監視(No.13) | E-04 L90 `"61","サーバー監視","13","サーバー監視","主機能"` | ○ |
| C-23 | 画面カテゴリはシステム監視 | E-05 L62 `"61","システム監視","サーバー監視"` | ○ |
| C-24 | テンプレートパスはmonitor/server/server.html | E-05 L62, E-01 L29 | ○ |
| C-25 | 権限不足時は403エラー画面へ | **根拠なし**（Shiroの一般的な挙動として推測） | △ |

## 4) 不足情報（Unknown / Missing）
- 権限エラー時の具体的なリダイレクト先（403.html等）のパス設定
  - 候補：Shiro設定ファイル / ShiroConfig.java / エラーハンドラ設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として信頼度が高い（96%）
- 権限エラー処理の詳細はフレームワーク依存のため、動作確認で補完推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 画面表示項目がソースコードと一致しているか確認
- [ ] 80%超警告表示の動作確認
- [ ] 権限なしユーザーでのアクセス時の挙動確認
- [ ] OSHIライブラリによる情報取得が正常に動作するか確認
