---
generated_at: 2026-01-08 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：62-キャッシュ監視

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **Ehcache設定ファイルの確認**：ehcache.xmlの具体的な設定内容は未確認
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/CacheController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/CacheService.java`
- E-03: `ruoyi-admin/src/main/resources/templates/monitor/cache/cache.html`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/monitor/cacheである | E-01 L21 `@RequestMapping("/monitor/cache")` | ○ |
| C-02 | monitor:cache:view権限が必要 | E-01 L29 `@RequiresPermissions("monitor:cache:view")` | ○ |
| C-03 | getNames APIがある | E-01 L38-43 `@PostMapping("/getNames")` | ○ |
| C-04 | getKeys APIがある | E-01 L45-52 `@PostMapping("/getKeys")` | ○ |
| C-05 | getValue APIがある | E-01 L54-62 `@PostMapping("/getValue")` | ○ |
| C-06 | clearCacheName APIがある | E-01 L64-71 `@PostMapping("/clearCacheName")` | ○ |
| C-07 | clearCacheKey APIがある | E-01 L73-80 `@PostMapping("/clearCacheKey")` | ○ |
| C-08 | clearAll APIがある | E-01 L82-89 `@GetMapping("/clearAll")` | ○ |
| C-09 | CacheServiceをAutowiredで注入 | E-01 L26-27 `@Autowired private CacheService cacheService` | ○ |
| C-10 | SYS_AUTH_CACHEを除外 | E-02 L26 `ArrayUtils.removeElement(cacheNames, Constants.SYS_AUTH_CACHE)` | ○ |
| C-11 | キー一覧をTreeSetで返却 | E-02 L37 `new TreeSet<>(CacheUtils.getCache(cacheName).keys())` | ○ |
| C-12 | CacheUtilsを使用してキャッシュ操作 | E-02 L8, L25, L37, L49, L59, L70, L81 | ○ |
| C-13 | 3カラムレイアウト構成 | E-03 L11, L39, L68 `col-sm-4`が3つ | ○ |
| C-14 | fragment-cache-namesを定義 | E-03 L29 `th:fragment="fragment-cache-names"` | ○ |
| C-15 | fragment-cache-kyesを定義 | E-03 L57 `th:fragment="fragment-cache-kyes"` | ○ |
| C-16 | fragment-cache-valueを定義 | E-03 L78 `th:fragment="fragment-cache-value"` | ○ |
| C-17 | 隠しフィールドでcacheNameを保持 | E-03 L8 `<input type="hidden" id="cacheName">` | ○ |
| C-18 | getCacheNames関数がある | E-03 L104-113 `function getCacheNames()` | ○ |
| C-19 | getCacheKeys関数がある | E-03 L115-131 `function getCacheKeys()` | ○ |
| C-20 | getCacheValue関数がある | E-03 L133-145 `function getCacheValue()` | ○ |
| C-21 | clearCacheName関数がある | E-03 L147-156 `function clearCacheName()` | ○ |
| C-22 | clearCacheKey関数がある | E-03 L158-167 `function clearCacheKey()` | ○ |
| C-23 | clearAll関数がある | E-03 L169-177 `function clearAll()` | ○ |
| C-24 | 成功メッセージ「刷新缓存列表成功」 | E-03 L110 `$.modal.msgSuccess("刷新缓存列表成功")` | ○ |
| C-25 | 成功メッセージ「刷新键名列表成功」 | E-03 L127-128 `$.modal.msgSuccess("刷新键名列表成功")` | ○ |
| C-26 | 成功メッセージ「清理全部缓存成功」 | E-03 L172 `$.modal.msgSuccess("清理全部缓存成功")` | ○ |
| C-27 | 関連機能はキャッシュ監視(No.14) | E-04 L91 `"62","キャッシュ監視","14","キャッシュ監視","主機能"` | ○ |
| C-28 | Ehcacheの設定ファイルehcache.xml | **根拠なし**（CacheUtils経由で推測、実際のファイル未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- Ehcache設定ファイル（ehcache.xml）の実際のパスと内容
  - 候補：ruoyi-admin/src/main/resources/ehcache/ / application.yml設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として信頼度が高い（96%）
- Ehcache設定の詳細はインフラ設計書で補完推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 7つのAPIエンドポイントが正常に動作するか確認
- [ ] SYS_AUTH_CACHEが一覧から除外されているか確認
- [ ] キャッシュクリア操作が正しく動作するか確認
- [ ] fragment部分更新が正常に動作するか確認
- [ ] 権限なしユーザーでのアクセス時の挙動確認
