---
generated_at: 2026-01-08 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-フォームビルダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. N/A（全主張に根拠あり）
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/tool/build/build.html`
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/tool/buildである | E-03 L64 テンプレートパス`tool/build/build.html` | ○ |
| C-02 | 画面タイトルは「表单构建器」 | E-01 L4 `th:include="include :: header('表单构建器')"` | ○ |
| C-03 | 左側パネルはcol-sm-5 | E-01 L13 `class="col-sm-5"` | ○ |
| C-04 | 右側パネルはcol-sm-7 | E-01 L132 `class="col-sm-7"` | ○ |
| C-05 | 文本框要素がある | E-01 L40-45 `form-group draggable`内にテキストボックス | ○ |
| C-06 | 多行文本框要素がある | E-01 L47-52 `textarea`要素 | ○ |
| C-07 | 密码框要素がある | E-01 L54-59 `type="password"` | ○ |
| C-08 | 下拉框要素がある | E-01 L60-70 `select`要素 | ○ |
| C-09 | 纯文本要素がある | E-01 L71-77 `form-control-static` | ○ |
| C-10 | 单选框要素がある | E-01 L78-86 `type="radio"` | ○ |
| C-11 | 复选框要素がある | E-01 L87-98 `type="checkbox"` | ○ |
| C-12 | 切换按钮要素がある | E-01 L99-109 `toggle-switch` | ○ |
| C-13 | 日期选择要素がある | E-01 L110-119 `input-group date` | ○ |
| C-14 | 提交/关闭ボタンがある | E-01 L121-126 `type="submit"`, `type="button"` | ○ |
| C-15 | 列数選択セレクトがある | E-01 L138-141 `id="n-columns"` | ○ |
| C-16 | ドロップエリアが3つある | E-01 L147-152 `.droppable.sortable`が3つ | ○ |
| C-17 | コードコピーボタンがある | E-01 L154 `id="copy-to-clipboard"` | ○ |
| C-18 | jQuery UIを使用 | E-01 L161 `th:src="@{/js/jquery-ui-1.10.4.min.js}"` | ○ |
| C-19 | datetimepickerを使用 | E-01 L5, L162 `datetimepicker-css`, `datetimepicker-js` | ○ |
| C-20 | beautifyhtml.jsを使用 | E-01 L163 `th:src="@{/ajax/libs/beautifyhtml/beautifyhtml.js}"` | ○ |
| C-21 | setup_draggable関数がある | E-01 L165 `setup_draggable()` | ○ |
| C-22 | 関連機能はコード生成(No.18) | E-02 L92 `"63","フォームビルダー","18","コード生成","補助機能"` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として信頼度が非常に高い（100%）
- クライアントサイドのみで動作するため、セキュリティリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] 各フォーム要素のドラッグ＆ドロップが正常に動作するか確認
- [ ] 列数切り替えが正常に動作するか確認
- [ ] HTML編集モーダルが正常に動作するか確認
- [ ] コードコピー機能が正常に動作するか確認
- [ ] 生成されたHTMLがBootstrapレイアウトに準拠しているか確認
