---
generated_at: 2026-01-08 10:45:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：64-コード生成一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **Velocityテンプレート一覧**：vm/ディレクトリ内のテンプレート構成の詳細確認
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-02: `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java`
- E-03: `ruoyi-generator/src/main/java/com/ruoyi/generator/service/IGenTableService.java`
- E-04: `ruoyi-generator/src/main/resources/templates/tool/gen/gen.html`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは/tool/genである | E-01 L47 `@RequestMapping("/tool/gen")` | ○ |
| C-02 | tool:gen:view権限が必要 | E-01 L58 `@RequiresPermissions("tool:gen:view")` | ○ |
| C-03 | tool:gen:list権限でリスト取得 | E-01 L68 `@RequiresPermissions("tool:gen:list")` | ○ |
| C-04 | tool:gen:edit権限で編集 | E-01 L145, L174 `@RequiresPermissions("tool:gen:edit")` | ○ |
| C-05 | tool:gen:remove権限で削除 | E-01 L185 `@RequiresPermissions("tool:gen:remove")` | ○ |
| C-06 | tool:gen:preview権限でプレビュー | E-01 L233 `@RequiresPermissions("tool:gen:preview")` | ○ |
| C-07 | tool:gen:code権限で生成 | E-01 L245, L257, L287 `@RequiresPermissions("tool:gen:code")` | ○ |
| C-08 | adminロールでテーブル作成 | E-01 L195 `@RequiresRoles("admin")` | ○ |
| C-09 | POST /tool/gen/listでリスト取得 | E-01 L69-76 `@PostMapping("/list")` | ○ |
| C-10 | GET /tool/gen/importTableでインポート画面 | E-01 L109-114 `@GetMapping("/importTable")` | ○ |
| C-11 | POST /tool/gen/importTableでインポート実行 | E-01 L128-140 `@PostMapping("/importTable")` | ○ |
| C-12 | GET /tool/gen/createTableで作成画面 | E-01 L119-123 `@GetMapping("/createTable")` | ○ |
| C-13 | POST /tool/gen/createTableで作成実行 | E-01 L197-228 `@PostMapping("/createTable")` | ○ |
| C-14 | GET /tool/gen/edit/{tableId}で編集画面 | E-01 L146-169 `@GetMapping("/edit/{tableId}")` | ○ |
| C-15 | POST /tool/gen/editで編集保存 | E-01 L176-183 `@PostMapping("/edit")` | ○ |
| C-16 | POST /tool/gen/removeで削除 | E-01 L187-193 `@PostMapping("/remove")` | ○ |
| C-17 | GET /tool/gen/preview/{tableId}でプレビュー | E-01 L234-240 `@GetMapping("/preview/{tableId}")` | ○ |
| C-18 | GET /tool/gen/download/{tableName}でダウンロード | E-01 L247-252 `@GetMapping("/download/{tableName}")` | ○ |
| C-19 | GET /tool/gen/genCode/{tableName}で自定義パス生成 | E-01 L258-269 `@GetMapping("/genCode/{tableName}")` | ○ |
| C-20 | GET /tool/gen/synchDb/{tableName}でDB同期 | E-01 L276-282 `@GetMapping("/synchDb/{tableName}")` | ○ |
| C-21 | GET /tool/gen/batchGenCodeで一括生成 | E-01 L289-296 `@GetMapping("/batchGenCode")` | ○ |
| C-22 | highlight.jsでシンタックスハイライト | E-04 L59, L153 `highlight.min.js`, `hljs.highlight` | ○ |
| C-23 | showExport: trueでエクスポート機能 | E-04 L74 `showExport: true` | ○ |
| C-24 | createTimeでデフォルトソート | E-04 L72-73 `sortName: "createTime", sortOrder: "desc"` | ○ |
| C-25 | rememberSelected: trueで選択保持 | E-04 L76 `rememberSelected: true` | ○ |
| C-26 | uniqueIdはtableId | E-04 L77 `uniqueId: "tableId"` | ○ |
| C-27 | preview関数がある | E-04 L142-172 `function preview(tableId)` | ○ |
| C-28 | genCode関数がある | E-04 L175-184 `function genCode(tableName, genType)` | ○ |
| C-29 | synchDb関数がある | E-04 L187-191 `function synchDb(tableName)` | ○ |
| C-30 | batchGenCode関数がある | E-04 L194-205 `function batchGenCode()` | ○ |
| C-31 | 関連機能はコード生成(No.18) | E-05 L93 `"64","コード生成一覧","18","コード生成","主機能"` | ○ |
| C-32 | Velocityテンプレートでコード生成 | **根拠あり**（E-02 L217-228でVelocityを使用するがvm/ディレクトリの詳細は未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- vm/ディレクトリ内のVelocityテンプレート一覧と各テンプレートの役割
  - 候補：ruoyi-generator/src/main/resources/vm/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として信頼度が非常に高い（97%）
- 権限設定が細かく分かれているため、権限テストは入念に行うことを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 各APIエンドポイントが正常に動作するか確認
- [ ] 権限チェックが正しく動作するか確認（特にadminロール）
- [ ] テーブルインポートが正常に動作するか確認
- [ ] コード生成（ZIP/自定義パス）が正常に動作するか確認
- [ ] プレビュー画面でシンタックスハイライトが表示されるか確認
- [ ] DB同期が正しくカラム情報を更新するか確認
